/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.TableParameters;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.GeoReference;
import io.crate.metadata.IndexReference;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.BooleanLiteral;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.CollectionColumnType;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ColumnStorageDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.GenericProperty;
import io.crate.sql.tree.IndexColumnConstraint;
import io.crate.sql.tree.IndexDefinition;
import io.crate.sql.tree.Literal;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.NotNullColumnConstraint;
import io.crate.sql.tree.ObjectColumnType;
import io.crate.sql.tree.PartitionedBy;
import io.crate.sql.tree.PrimaryKeyConstraint;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SubscriptExpression;
import io.crate.sql.tree.Table;
import io.crate.sql.tree.TableElement;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.StringType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class MetadataToASTNodeResolver {
    public static CreateTable resolveCreateTable(DocTableInfo info) {
        Extractor extractor = new Extractor(info);
        return extractor.extractCreateTable();
    }

    public static Expression expressionFromColumn(ColumnIdent ident) {
        Expression fqn = new QualifiedNameReference(QualifiedName.of(ident.getRoot().fqn(), new String[0]));
        for (String child : ident.path()) {
            fqn = new SubscriptExpression(fqn, Literal.fromObject(child));
        }
        return fqn;
    }

    static ColumnType<Expression> dataTypeToColumnType(ColumnIdent column, DataType<?> type, ColumnPolicy columnPolicy, Function<ColumnIdent, List<ColumnDefinition<Expression>>> convertChildColumn) {
        if (type.id() == 12) {
            return new ObjectColumnType<Expression>(columnPolicy.name(), convertChildColumn.apply(column));
        }
        if (type.id() == 100) {
            DataType innerType = ((ArrayType)type).innerType();
            return new CollectionColumnType<Expression>(MetadataToASTNodeResolver.dataTypeToColumnType(column, innerType, columnPolicy, convertChildColumn));
        }
        if (type.id() == 4) {
            StringType stringType = (StringType)type;
            if (stringType.unbound()) {
                return new ColumnType<Expression>(type.getName());
            }
            return new ColumnType<Expression>("VARCHAR", List.of(Integer.valueOf(stringType.lengthLimit())));
        }
        return new ColumnType<Expression>(type.getName());
    }

    private static class Extractor {
        private final DocTableInfo tableInfo;

        public Extractor(DocTableInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        private Table<Expression> extractTable() {
            return new Table<Expression>(QualifiedName.of(this.tableInfo.ident().fqn(), new String[0]), false);
        }

        private List<TableElement<Expression>> extractTableElements() {
            ArrayList<TableElement<Expression>> elements = new ArrayList<TableElement<Expression>>();
            elements.addAll(this.extractColumnDefinitions(null));
            PrimaryKeyConstraint<Expression> pk = this.extractPrimaryKeyConstraint();
            if (pk != null) {
                elements.add(pk);
            }
            elements.addAll(this.extractIndexDefinitions());
            this.tableInfo.checkConstraints().stream().map(chk -> new CheckConstraint<Expression>(chk.name(), chk.columnName(), SqlParser.createExpression(chk.expressionStr()), chk.expressionStr())).forEach(elements::add);
            return elements;
        }

        private List<ColumnDefinition<Expression>> extractColumnDefinitions(@Nullable ColumnIdent parent) {
            Iterator<Reference> referenceIterator = this.tableInfo.iterator();
            ArrayList<ColumnDefinition<Expression>> elements = new ArrayList<ColumnDefinition<Expression>>();
            while (referenceIterator.hasNext()) {
                GenericProperties<Literal> properties;
                Reference info = referenceIterator.next();
                ColumnIdent ident = info.column();
                if (ident.isSystemColumn() || parent != null && !ident.isChildOf(parent) || parent == null && !ident.path().isEmpty() || parent != null && ident.getParent().compareTo(parent) > 0) continue;
                ColumnType<Expression> columnType = MetadataToASTNodeResolver.dataTypeToColumnType(ident, info.valueType(), info.columnPolicy(), this::extractColumnDefinitions);
                ArrayList constraints = new ArrayList();
                if (!info.isNullable()) {
                    constraints.add(new NotNullColumnConstraint());
                }
                if (info.indexType().equals((Object)Reference.IndexType.NO) && info.valueType().id() != 12 && (info.valueType().id() != 100 || ((ArrayType)info.valueType()).innerType().id() != 12)) {
                    constraints.add(IndexColumnConstraint.off());
                } else if (info.indexType().equals((Object)Reference.IndexType.ANALYZED)) {
                    String analyzer = this.tableInfo.getAnalyzerForColumnIdent(ident);
                    properties = new GenericProperties<Literal>();
                    if (analyzer != null) {
                        properties.add(new GenericProperty<StringLiteral>(FulltextAnalyzerResolver.CustomType.ANALYZER.getName(), new StringLiteral(analyzer)));
                    }
                    constraints.add(new IndexColumnConstraint("fulltext", properties));
                } else if (info.valueType().equals(DataTypes.GEO_SHAPE)) {
                    GeoReference geoReference = (GeoReference)info;
                    properties = new GenericProperties();
                    if (geoReference.distanceErrorPct() != null) {
                        properties.add(new GenericProperty<Literal>("distance_error_pct", StringLiteral.fromObject(geoReference.distanceErrorPct())));
                    }
                    if (geoReference.precision() != null) {
                        properties.add(new GenericProperty<Literal>("precision", StringLiteral.fromObject(geoReference.precision())));
                    }
                    if (geoReference.treeLevels() != null) {
                        properties.add(new GenericProperty<Literal>("tree_levels", StringLiteral.fromObject(geoReference.treeLevels())));
                    }
                    constraints.add(new IndexColumnConstraint(geoReference.geoTree(), properties));
                }
                Expression generatedExpression = null;
                if (info instanceof GeneratedReference) {
                    String formattedExpression = ((GeneratedReference)info).formattedGeneratedExpression();
                    generatedExpression = SqlParser.createExpression(formattedExpression);
                }
                Expression defaultExpression = null;
                Symbol defaultExpr = info.defaultExpression();
                if (defaultExpr != null) {
                    String symbol = defaultExpr.toString(Style.UNQUALIFIED);
                    defaultExpression = SqlParser.createExpression(symbol);
                }
                if (info.isColumnStoreDisabled()) {
                    GenericProperties<Literal> properties2 = new GenericProperties<Literal>();
                    properties2.add(new GenericProperty<Literal>("columnstore", BooleanLiteral.fromObject(false)));
                    constraints.add(new ColumnStorageDefinition(properties2));
                }
                String columnName = ident.isTopLevel() ? ident.name() : ident.path().get(ident.path().size() - 1);
                elements.add(new ColumnDefinition<Expression>(columnName, defaultExpression, generatedExpression, columnType, constraints));
            }
            return elements;
        }

        private PrimaryKeyConstraint<Expression> extractPrimaryKeyConstraint() {
            if (!this.tableInfo.primaryKey().isEmpty()) {
                if (this.tableInfo.primaryKey().size() == 1 && this.tableInfo.primaryKey().get(0).isSystemColumn()) {
                    return null;
                }
                return new PrimaryKeyConstraint<Expression>(this.expressionsFromColumns(this.tableInfo.primaryKey()));
            }
            return null;
        }

        private List<IndexDefinition<Expression>> extractIndexDefinitions() {
            ArrayList<IndexDefinition<Expression>> elements = new ArrayList<IndexDefinition<Expression>>();
            Iterator<IndexReference> indexColumns = this.tableInfo.indexColumns();
            if (indexColumns != null) {
                while (indexColumns.hasNext()) {
                    IndexReference indexRef = indexColumns.next();
                    String name = indexRef.column().name();
                    List<Expression> columns = this.expressionsFromReferences(indexRef.columns());
                    if (indexRef.indexType().equals((Object)Reference.IndexType.ANALYZED)) {
                        String analyzer = indexRef.analyzer();
                        GenericProperties<StringLiteral> properties = new GenericProperties<StringLiteral>();
                        if (analyzer != null) {
                            properties.add(new GenericProperty<StringLiteral>(FulltextAnalyzerResolver.CustomType.ANALYZER.getName(), new StringLiteral(analyzer)));
                        }
                        elements.add(new IndexDefinition<Expression>(name, "fulltext", columns, properties));
                        continue;
                    }
                    if (!indexRef.indexType().equals((Object)Reference.IndexType.NOT_ANALYZED)) continue;
                    elements.add(new IndexDefinition<Expression>(name, "plain", columns, GenericProperties.empty()));
                }
            }
            return elements;
        }

        private Optional<PartitionedBy<Expression>> createPartitionedBy() {
            if (this.tableInfo.partitionedBy().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new PartitionedBy<Expression>(this.expressionsFromColumns(this.tableInfo.partitionedBy())));
        }

        private Optional<ClusteredBy<Expression>> createClusteredBy() {
            ColumnIdent clusteredByColumn = this.tableInfo.clusteredBy();
            Expression clusteredBy = clusteredByColumn == null || clusteredByColumn.isSystemColumn() ? null : MetadataToASTNodeResolver.expressionFromColumn(clusteredByColumn);
            LongLiteral numShards = new LongLiteral(this.tableInfo.numberOfShards());
            return Optional.of(new ClusteredBy<LongLiteral>(Optional.ofNullable(clusteredBy), Optional.of(numShards)));
        }

        private GenericProperties<Expression> extractTableProperties() {
            GenericProperties<Expression> properties = new GenericProperties<Expression>();
            StringLiteral numReplicas = new StringLiteral(this.tableInfo.numberOfReplicas());
            properties.add(new GenericProperty<StringLiteral>(TableParameters.NUMBER_OF_REPLICAS.getKey(), numReplicas));
            TreeMap<String, Object> tableParameters = new TreeMap<String, Object>(TableParameters.tableParametersFromIndexMetadata(this.tableInfo.parameters()));
            for (Map.Entry<String, Object> entry : tableParameters.entrySet()) {
                properties.add(new GenericProperty<Literal>(TableParameters.stripIndexPrefix(entry.getKey()), Literal.fromObject(entry.getValue())));
            }
            properties.add(new GenericProperty<StringLiteral>("column_policy", new StringLiteral(this.tableInfo.columnPolicy().lowerCaseName())));
            return properties;
        }

        private CreateTable<Expression> extractCreateTable() {
            Table<Expression> table = this.extractTable();
            List tableElements = this.extractTableElements();
            Optional partitionedBy = this.createPartitionedBy();
            Optional clusteredBy = this.createClusteredBy();
            return new CreateTable<Expression>(table, tableElements, partitionedBy, clusteredBy, this.extractTableProperties(), true);
        }

        private List<Expression> expressionsFromReferences(List<Reference> columns) {
            ArrayList<Expression> expressions = new ArrayList<Expression>(columns.size());
            for (Reference ident : columns) {
                expressions.add(MetadataToASTNodeResolver.expressionFromColumn(ident.column()));
            }
            return expressions;
        }

        private List<Expression> expressionsFromColumns(List<ColumnIdent> columns) {
            ArrayList<Expression> expressions = new ArrayList<Expression>(columns.size());
            for (ColumnIdent ident : columns) {
                expressions.add(MetadataToASTNodeResolver.expressionFromColumn(ident));
            }
            return expressions;
        }
    }
}

