/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.relations.AliasedAnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.expression.symbol.FieldReplacer;
import io.crate.expression.symbol.Symbol;
import java.util.function.Function;

public class MaybeAliasedStatement {
    private final AnalyzedRelation relation;
    private final Function<? super Symbol, ? extends Symbol> mapper;

    public static MaybeAliasedStatement analyze(AnalyzedRelation relation) {
        if (relation instanceof AliasedAnalyzedRelation) {
            AliasedAnalyzedRelation aliasedAnalyzedRelation = (AliasedAnalyzedRelation)relation;
            return new MaybeAliasedStatement(aliasedAnalyzedRelation.relation(), FieldReplacer.bind(aliasedAnalyzedRelation::resolveField));
        }
        return new MaybeAliasedStatement(relation, s -> s);
    }

    private MaybeAliasedStatement(AnalyzedRelation relation, Function<? super Symbol, ? extends Symbol> mapper) {
        this.relation = relation;
        this.mapper = mapper;
    }

    AnalyzedRelation nonAliasedRelation() {
        return this.relation;
    }

    Symbol maybeMapFields(Symbol symbol) {
        return this.mapper.apply(symbol);
    }
}

