/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;

public class MatchOptionsAnalysis {
    private static final Predicate<Object> POSITIVE_NUMBER = x -> x instanceof Number && ((Number)x).doubleValue() > 0.0;
    private static final Predicate<Object> IS_STRING = x -> x instanceof String;
    private static final Predicate<Object> IS_NUMBER = x -> x instanceof Number;
    private static final Predicate<Object> NUMBER_OR_STRING = IS_NUMBER.or(IS_STRING);
    private static final Map<String, Predicate<Object>> ALLOWED_SETTINGS = Map.ofEntries(Map.entry("analyzer", IS_STRING), Map.entry("boost", POSITIVE_NUMBER), Map.entry("cutoff_frequency", POSITIVE_NUMBER), Map.entry("fuzziness", NUMBER_OR_STRING), Map.entry("fuzzy_rewrite", IS_STRING), Map.entry("max_expansions", POSITIVE_NUMBER), Map.entry("minimum_should_match", NUMBER_OR_STRING), Map.entry("operator", Predicates.in(List.of("or", "and", "OR", "AND"))), Map.entry("prefix_length", POSITIVE_NUMBER), Map.entry("rewrite", IS_STRING), Map.entry("slop", POSITIVE_NUMBER), Map.entry("tie_breaker", IS_NUMBER), Map.entry("zero_terms_query", IS_STRING));

    public static void validate(Map<String, Object> options) {
        for (Map.Entry<String, Object> e : options.entrySet()) {
            String optionName = e.getKey();
            Predicate<Object> validator = ALLOWED_SETTINGS.get(optionName);
            if (validator == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "unknown match option '%s'", optionName));
            }
            Object value = e.getValue();
            if (validator.test(value)) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid value for option '%s': %s", optionName, value));
        }
    }
}

