/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedInsertStatement;
import io.crate.analyze.MetadataToASTNodeResolver;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.ValueNormalizer;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.ExcludedFieldProvider;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.FullQualifiedNameFieldProvider;
import io.crate.analyze.relations.NameFieldProvider;
import io.crate.analyze.relations.ParentRelations;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.analyze.relations.StatementAnalysisContext;
import io.crate.analyze.relations.select.SelectAnalysis;
import io.crate.analyze.relations.select.SelectAnalyzer;
import io.crate.common.collections.Lists2;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;

class InsertAnalyzer {
    private final NodeContext nodeCtx;
    private final Schemas schemas;
    private final RelationAnalyzer relationAnalyzer;

    InsertAnalyzer(NodeContext nodeCtx, Schemas schemas, RelationAnalyzer relationAnalyzer) {
        this.nodeCtx = nodeCtx;
        this.schemas = schemas;
        this.relationAnalyzer = relationAnalyzer;
    }

    public AnalyzedInsertStatement analyze(Insert<Expression> insert, ParamTypeHints typeHints, CoordinatorTxnCtx txnCtx) {
        List<Symbol> returnValues;
        boolean ignoreDuplicateKeys;
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.resolveTableInfo(insert.table().getName(), Operation.INSERT, txnCtx.sessionContext().sessionUser(), txnCtx.sessionContext().searchPath());
        ArrayList<Reference> targetColumns = new ArrayList<Reference>(InsertAnalyzer.resolveTargetColumns(insert.columns(), tableInfo));
        AnalyzedRelation subQueryRelation = this.relationAnalyzer.analyze(insert.insertSource(), new StatementAnalysisContext(typeHints, Operation.READ, txnCtx, targetColumns));
        InsertAnalyzer.ensureClusteredByPresentOrNotRequired(targetColumns, tableInfo);
        InsertAnalyzer.checkSourceAndTargetColsForLengthAndTypesCompatibility(targetColumns, subQueryRelation.outputs());
        DocTableRelation tableRelation = new DocTableRelation(tableInfo);
        NameFieldProvider fieldProvider = new NameFieldProvider(tableRelation);
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, fieldProvider, null, Operation.READ);
        InsertAnalyzer.verifyOnConflictTargets(expressionAnalyzer, tableInfo, insert.duplicateKeyContext());
        Map<Reference, Symbol> onDuplicateKeyAssignments = this.processUpdateAssignments(tableRelation, targetColumns, typeHints, txnCtx, this.nodeCtx, fieldProvider, insert.duplicateKeyContext());
        boolean bl = ignoreDuplicateKeys = insert.duplicateKeyContext().getType() == Insert.DuplicateKeyContext.Type.ON_CONFLICT_DO_NOTHING;
        if (insert.returningClause().isEmpty()) {
            returnValues = null;
        } else {
            ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
            Map<RelationName, AnalyzedRelation> sources = Map.of(tableRelation.relationName(), tableRelation);
            ExpressionAnalyzer sourceExprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, new FullQualifiedNameFieldProvider(sources, ParentRelations.NO_PARENTS, txnCtx.sessionContext().searchPath().currentSchema()), null);
            SelectAnalysis selectAnalysis = SelectAnalyzer.analyzeSelectItems(insert.returningClause(), sources, sourceExprAnalyzer, exprCtx);
            returnValues = selectAnalysis.outputSymbols();
        }
        return new AnalyzedInsertStatement(subQueryRelation, tableInfo, targetColumns, ignoreDuplicateKeys, onDuplicateKeyAssignments, returnValues);
    }

    private static void verifyOnConflictTargets(ExpressionAnalyzer expressionAnalyzer, DocTableInfo docTable, Insert.DuplicateKeyContext<Expression> duplicateKeyContext) {
        List<Expression> constraintColumns = duplicateKeyContext.getConstraintColumns();
        if (constraintColumns.isEmpty()) {
            return;
        }
        List<ColumnIdent> pkColumnIdents = docTable.primaryKey();
        if (constraintColumns.size() != pkColumnIdents.size()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Number of conflict targets (%s) did not match the number of primary key columns (%s)", constraintColumns, pkColumnIdents));
        }
        ExpressionAnalysisContext ctx = new ExpressionAnalysisContext();
        List<Symbol> conflictTargets = Lists2.map(constraintColumns, x -> {
            try {
                return expressionAnalyzer.convert((Expression)x, ctx);
            }
            catch (ColumnUnknownException e) {
                if (x instanceof QualifiedNameReference) {
                    QualifiedName name = ((QualifiedNameReference)x).getName();
                    Expression subscriptExpression = MetadataToASTNodeResolver.expressionFromColumn(ColumnIdent.fromPath(name.toString()));
                    return expressionAnalyzer.convert(subscriptExpression, ctx);
                }
                throw e;
            }
        });
        for (Symbol conflictTarget : conflictTargets) {
            if (pkColumnIdents.contains(Symbols.pathFromSymbol(conflictTarget))) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Conflict target (%s) did not match the primary key columns (%s)", conflictTarget, pkColumnIdents));
        }
    }

    private static Collection<Reference> resolveTargetColumns(Collection<String> targetColumnNames, DocTableInfo targetTable) {
        if (targetColumnNames.isEmpty()) {
            return targetTable.columns();
        }
        LinkedHashSet<Reference> columns = new LinkedHashSet<Reference>(targetColumnNames.size());
        for (String targetColumnName : targetColumnNames) {
            Reference targetReference;
            ColumnIdent columnIdent = ColumnIdent.fromPath(targetColumnName);
            Reference reference = targetTable.getReference(columnIdent);
            if (reference == null) {
                DynamicReference dynamicReference = targetTable.getDynamic(columnIdent, true);
                if (dynamicReference == null) {
                    throw new ColumnUnknownException(targetColumnName, targetTable.ident());
                }
                targetReference = dynamicReference;
            } else {
                targetReference = reference;
            }
            if (columns.add(targetReference)) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "reference '%s' repeated", targetColumnName));
        }
        return columns;
    }

    private static void ensureClusteredByPresentOrNotRequired(List<Reference> targetColumnRefs, DocTableInfo tableInfo) {
        GeneratedReference generatedClusteredBy;
        List<ColumnIdent> topLevelDependencies;
        ColumnIdent clusteredBy = tableInfo.clusteredBy();
        if (clusteredBy == null || clusteredBy.equals(DocSysColumns.ID)) {
            return;
        }
        Reference clusteredByRef = tableInfo.getReference(clusteredBy);
        if (clusteredByRef.defaultExpression() != null) {
            return;
        }
        ColumnIdent clusteredByRoot = clusteredBy.getRoot();
        List<ColumnIdent> targetColumns = Lists2.mapLazy(targetColumnRefs, Reference::column);
        if (targetColumns.contains(clusteredByRoot)) {
            return;
        }
        if (clusteredByRef instanceof GeneratedReference && targetColumns.containsAll(topLevelDependencies = Lists2.mapLazy((generatedClusteredBy = (GeneratedReference)clusteredByRef).referencedReferences(), x -> x.column().getRoot()))) {
            return;
        }
        throw new IllegalArgumentException("Column `" + clusteredBy + "` is required but is missing from the insert statement");
    }

    private static void checkSourceAndTargetColsForLengthAndTypesCompatibility(List<Reference> targetColumns, List<Symbol> sources) {
        if (targetColumns.size() != sources.size()) {
            Collector<CharSequence, ?, String> commaJoiner = Collectors.joining(", ");
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Number of target columns (%s) of insert statement doesn't match number of source columns (%s)", targetColumns.stream().map(r -> r.column().sqlFqn()).collect(commaJoiner), sources.stream().map(Symbol::toString).collect(commaJoiner)));
        }
        for (int i = 0; i < targetColumns.size(); ++i) {
            Reference targetCol = targetColumns.get(i);
            Symbol source = sources.get(i);
            DataType<?> targetType = targetCol.valueType();
            if (targetType.id() == DataTypes.UNDEFINED.id() || source.valueType().isConvertableTo(targetType, false)) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The type '%s' of the insert source '%s' is not convertible to the type '%s' of target column '%s'", source.valueType(), source, targetType, targetCol.column().fqn()));
        }
    }

    private static Map<Reference, Symbol> getUpdateAssignments(DocTableRelation targetTable, List<Reference> targetCols, ExpressionAnalyzer exprAnalyzer, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints, Insert.DuplicateKeyContext<Expression> duplicateKeyContext) {
        if (duplicateKeyContext.getAssignments().isEmpty()) {
            return Collections.emptyMap();
        }
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        ValuesResolver valuesResolver = new ValuesResolver(targetCols);
        FieldProvider<Symbol> fieldProvider = duplicateKeyContext.getType() == Insert.DuplicateKeyContext.Type.ON_CONFLICT_DO_UPDATE_SET ? new ExcludedFieldProvider(new NameFieldProvider(targetTable), valuesResolver) : new NameFieldProvider(targetTable);
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, nodeCtx, paramTypeHints, fieldProvider, null);
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(nodeCtx, RowGranularity.CLUSTER, null, targetTable);
        HashMap<Reference, Symbol> updateAssignments = new HashMap<Reference, Symbol>(duplicateKeyContext.getAssignments().size());
        for (Assignment<Expression> assignment : duplicateKeyContext.getAssignments()) {
            Reference targetCol = (Reference)exprAnalyzer.convert(assignment.columnName(), exprCtx);
            Symbol valueSymbol = ValueNormalizer.normalizeInputForReference(normalizer.normalize(expressionAnalyzer.convert(assignment.expression(), exprCtx), txnCtx), targetCol, targetTable.tableInfo(), s -> normalizer.normalize((Symbol)s, txnCtx));
            updateAssignments.put(targetCol, valueSymbol);
        }
        return updateAssignments;
    }

    private Map<Reference, Symbol> processUpdateAssignments(DocTableRelation tableRelation, List<Reference> targetColumns, ParamTypeHints paramTypeHints, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, FieldProvider<?> fieldProvider, Insert.DuplicateKeyContext<Expression> duplicateKeyContext) {
        if (duplicateKeyContext.getAssignments().isEmpty()) {
            return Collections.emptyMap();
        }
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(coordinatorTxnCtx, nodeCtx, paramTypeHints, fieldProvider, null, Operation.UPDATE);
        return InsertAnalyzer.getUpdateAssignments(tableRelation, targetColumns, expressionAnalyzer, coordinatorTxnCtx, nodeCtx, paramTypeHints, duplicateKeyContext);
    }

    private static class ValuesResolver
    implements io.crate.analyze.ValuesResolver {
        private final List<Reference> targetColumns;

        ValuesResolver(List<Reference> targetColumns) {
            this.targetColumns = targetColumns;
        }

        @Override
        public Symbol allocateAndResolve(Symbol argumentColumn) {
            int i;
            int n = i = argumentColumn instanceof Reference ? this.targetColumns.indexOf(argumentColumn) : -1;
            if (i < 0) {
                throw new IllegalArgumentException(Symbols.format("Column '%s' that is used in the VALUES() expression is not part of the target column list", argumentColumn));
            }
            return new InputColumn(i, argumentColumn.valueType());
        }
    }
}

