/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.common.collections.Lists2;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.doc.DocSysColumns;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;

public class Id {
    private static final Function<List<String>, String> RANDOM_ID = ignored -> UUIDs.base64UUID();
    private static final Function<List<String>, String> ONLY_ITEM_NULL_VALIDATION = keyValues -> Id.ensureNonNull((String)Lists2.getOnlyElement(keyValues));
    private static final Function<List<String>, String> ONLY_ITEM = Lists2::getOnlyElement;

    private static Function<List<String>, String> compileWithNullValidation(int numPks, int clusteredByPosition) {
        switch (numPks) {
            case 0: {
                return RANDOM_ID;
            }
            case 1: {
                return ONLY_ITEM_NULL_VALIDATION;
            }
        }
        return keyValues -> {
            if (keyValues.size() != numPks) {
                throw new IllegalArgumentException("Missing primary key values");
            }
            return Id.encode(keyValues, clusteredByPosition);
        };
    }

    public static Function<List<String>, String> compile(int numPks, int clusteredByPosition) {
        if (numPks == 1) {
            return ONLY_ITEM;
        }
        return Id.compileWithNullValidation(numPks, clusteredByPosition);
    }

    public static Function<List<String>, String> compileWithNullValidation(List<ColumnIdent> pkColumns, ColumnIdent clusteredBy) {
        int numPks = pkColumns.size();
        if (numPks == 1 && Lists2.getOnlyElement(pkColumns).equals(DocSysColumns.ID)) {
            return RANDOM_ID;
        }
        int idx = -1;
        if (clusteredBy != null) {
            idx = pkColumns.indexOf(clusteredBy);
        }
        return Id.compileWithNullValidation(numPks, idx);
    }

    @Nonnull
    private static <T> T ensureNonNull(@Nullable T pkValue) throws IllegalArgumentException {
        if (pkValue == null) {
            throw new IllegalArgumentException("A primary key value must not be NULL");
        }
        return pkValue;
    }

    private static String encode(List<String> values, int clusteredByPosition) {
        BytesStreamOutput out = new BytesStreamOutput(Id.estimateSize(values));
        try {
            int size = values.size();
            out.writeVInt(size);
            if (clusteredByPosition >= 0) {
                out.writeBytesRef(new BytesRef((CharSequence)Id.ensureNonNull(values.get(clusteredByPosition))));
            }
            for (int i = 0; i < size; ++i) {
                if (i == clusteredByPosition) continue;
                out.writeBytesRef(new BytesRef((CharSequence)Id.ensureNonNull(values.get(i))));
            }
            String string = Base64.getEncoder().encodeToString(BytesReference.toBytes(out.bytes()));
            out.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static int estimateSize(Iterable<String> values) {
        int expectedEncodedSize = 0;
        for (String value : values) {
            expectedEncodedSize += 5 + (value != null ? value.length() : 0);
        }
        return expectedEncodedSize;
    }
}

