/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.TableParameters;
import io.crate.sql.tree.GenericProperties;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class GenericPropertiesConverter {
    private static final String INVALID_SETTING_MESSAGE = "setting '%s' not supported";

    public static void genericPropertyToSetting(Settings.Builder builder, String name, Object value) {
        if (value instanceof String[]) {
            builder.putList(name, (String[])value);
        } else if (value instanceof List) {
            builder.putList(name, (List)value);
        } else {
            builder.put(name, value.toString());
        }
    }

    public static Settings genericPropertiesToSettings(GenericProperties<Object> genericProperties, Map<String, Setting<?>> supportedSettings) {
        Settings.Builder builder = Settings.builder();
        GenericPropertiesConverter.genericPropertiesToSettings(builder, genericProperties, settingKey -> {
            if (!supportedSettings.containsKey(settingKey)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, INVALID_SETTING_MESSAGE, settingKey));
            }
        });
        return builder.build();
    }

    public static Settings genericPropertiesToSettings(GenericProperties<Object> genericProperties) {
        Settings.Builder builder = Settings.builder();
        GenericPropertiesConverter.genericPropertiesToSettings(builder, genericProperties, settingKey -> {});
        return builder.build();
    }

    private static void genericPropertiesToSettings(Settings.Builder builder, GenericProperties<Object> genericProperties, Consumer<String> settingKeyValidator) {
        for (Map.Entry<String, Object> entry : genericProperties.properties().entrySet()) {
            settingKeyValidator.accept(entry.getKey());
            builder.put(entry.getKey(), entry.getValue().toString());
        }
    }

    static void settingsFromProperties(Settings.Builder builder, GenericProperties<Object> properties, Map<String, Setting<?>> supportedSettings, boolean setDefaults, Predicate<String> ignoreProperty, String invalidMessage) {
        if (setDefaults) {
            GenericPropertiesConverter.setDefaults(builder, supportedSettings);
        }
        for (Map.Entry<String, Object> entry : properties.properties().entrySet()) {
            String groupName;
            String settingName = entry.getKey();
            if (ignoreProperty.test(settingName) || (groupName = GenericPropertiesConverter.getPossibleGroup(settingName)) != null && ignoreProperty.test(groupName)) continue;
            SettingHolder settingHolder = GenericPropertiesConverter.getSupportedSetting(supportedSettings, settingName);
            if (settingHolder == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, invalidMessage, entry.getKey()));
            }
            settingHolder.apply(builder, entry.getValue());
        }
    }

    static void resetSettingsFromProperties(Settings.Builder builder, List<String> properties, Map<String, Setting<?>> supportedSettings, Predicate<String> ignoreProperty, String invalidMessage) {
        for (String name : properties) {
            String groupName;
            if (ignoreProperty.test(name) || (groupName = GenericPropertiesConverter.getPossibleGroup(name)) != null && ignoreProperty.test(groupName)) continue;
            SettingHolder settingHolder = GenericPropertiesConverter.getSupportedSetting(supportedSettings, name);
            if (settingHolder == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, invalidMessage, name));
            }
            settingHolder.reset(builder);
        }
    }

    private static void setDefaults(Settings.Builder builder, Map<String, Setting<?>> supportedSettings) {
        for (Map.Entry<String, Setting<?>> entry : supportedSettings.entrySet()) {
            SettingHolder settingHolder = new SettingHolder(entry.getValue());
            if (TableParameters.SETTINGS_NOT_INCLUDED_IN_DEFAULT.contains(settingHolder.setting)) continue;
            settingHolder.applyDefault(builder);
        }
    }

    @Nullable
    private static SettingHolder getSupportedSetting(Map<String, Setting<?>> supportedSettings, String settingName) {
        String groupKey;
        Setting<Object> setting = supportedSettings.get(settingName);
        if (setting == null && (groupKey = GenericPropertiesConverter.getPossibleGroup(settingName)) != null && (setting = supportedSettings.get(groupKey)) instanceof Setting.AffixSetting) {
            setting = ((Setting.AffixSetting)setting).getConcreteSetting("index." + settingName);
            return new SettingHolder(setting, true);
        }
        if (setting != null) {
            return new SettingHolder(setting);
        }
        return null;
    }

    @Nullable
    private static String getPossibleGroup(String key) {
        int idx = key.lastIndexOf(46);
        if (idx > 0) {
            return key.substring(0, idx);
        }
        return null;
    }

    private static class SettingHolder {
        private final Setting<?> setting;
        private final boolean isAffixSetting;
        private final boolean isChildOfAffixSetting;

        SettingHolder(Setting<?> setting) {
            this(setting, false);
        }

        SettingHolder(Setting<?> setting, boolean isChildOfAffixSetting) {
            this.setting = setting;
            this.isAffixSetting = setting instanceof Setting.AffixSetting;
            this.isChildOfAffixSetting = isChildOfAffixSetting;
        }

        void applyDefault(Settings.Builder builder) {
            if (this.isAffixSetting) {
                return;
            }
            Object value = this.setting.getDefault(Settings.EMPTY);
            if (value instanceof Settings) {
                builder.put((Settings)value);
            } else {
                builder.put(this.setting.getKey(), value.toString());
            }
        }

        void apply(Settings.Builder builder, Object valueSymbol) {
            if (this.isAffixSetting) {
                throw new IllegalArgumentException("Cannot change a dynamic group setting, only concrete settings allowed.");
            }
            Settings.Builder singleSettingBuilder = Settings.builder();
            GenericPropertiesConverter.genericPropertyToSetting(singleSettingBuilder, this.setting.getKey(), valueSymbol);
            Object value = this.setting.get(singleSettingBuilder.build());
            if (value instanceof Settings) {
                builder.put((Settings)value);
            } else {
                builder.put(this.setting.getKey(), value.toString());
            }
        }

        void reset(Settings.Builder builder) {
            if (this.isAffixSetting) {
                throw new IllegalArgumentException("Cannot change a dynamic group setting, only concrete settings allowed.");
            }
            Object value = this.setting.getDefault(Settings.EMPTY);
            if (this.isChildOfAffixSetting) {
                builder.putNull(this.setting.getKey());
            } else if (value instanceof Settings) {
                builder.put((Settings)value);
            } else {
                builder.put(this.setting.getKey(), value.toString());
            }
        }
    }
}

