/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.DataTypeAnalyzer;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.sql.tree.FunctionArgument;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class FunctionArgumentDefinition
implements Writeable,
ToXContent {
    @Nullable
    private final String name;
    private final DataType<?> type;

    private FunctionArgumentDefinition(@Nullable String name, DataType<?> dataType) {
        this.name = name;
        this.type = dataType;
    }

    public FunctionArgumentDefinition(StreamInput in) throws IOException {
        this.name = in.readOptionalString();
        this.type = DataTypes.fromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        DataTypes.toStream(this.type, out);
    }

    public static FunctionArgumentDefinition of(String name, DataType<?> dataType) {
        return new FunctionArgumentDefinition(name, dataType);
    }

    public static FunctionArgumentDefinition of(DataType<?> dataType) {
        return new FunctionArgumentDefinition(null, dataType);
    }

    public static List<FunctionArgumentDefinition> toFunctionArgumentDefinitions(List<FunctionArgument> arguments) {
        return arguments.stream().map(arg -> FunctionArgumentDefinition.of(arg.name(), DataTypeAnalyzer.convert(arg.type()))).collect(Collectors.toList());
    }

    public DataType<?> type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionArgumentDefinition that = (FunctionArgumentDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return "FunctionArgumentDefinition{name='" + this.name + "', type=" + this.type + "}";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("name", this.name).field("data_type");
        UserDefinedFunctionMetadata.DataTypeXContent.toXContent(this.type, builder, params);
        builder.endObject();
        return builder;
    }

    public static FunctionArgumentDefinition fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Expected a START_OBJECT but got " + parser.currentToken());
        }
        String name = null;
        DataType type = DataTypes.UNDEFINED;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                if ("name".equals(parser.currentName())) {
                    name = FunctionArgumentDefinition.parseStringField(parser);
                    continue;
                }
                if ("data_type".equals(parser.currentName())) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new IllegalArgumentException("Expected a START_OBJECT but got " + parser.currentToken());
                    }
                    type = UserDefinedFunctionMetadata.DataTypeXContent.fromXContent(parser);
                    continue;
                }
                throw new IllegalArgumentException("Expected \"name\" or \"data_type\", but got " + parser.currentName());
            }
            throw new IllegalArgumentException("Expected a FIELD_NAME but got " + parser.currentToken());
        }
        return new FunctionArgumentDefinition(name, type);
    }

    private static String parseStringField(XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.VALUE_STRING && parser.currentToken() != XContentParser.Token.VALUE_NULL) {
            throw new IllegalArgumentException("Failed to parse string field");
        }
        return parser.textOrNull();
    }
}

