/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.Analysis;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.Analyzer;
import io.crate.analyze.ExplainAnalyzedStatement;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.planner.node.management.ExplainPlan;
import io.crate.profile.ProfilingContext;
import io.crate.profile.Timer;
import io.crate.sql.SqlFormatter;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.Explain;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.Statement;
import java.util.List;

public class ExplainStatementAnalyzer {
    private final Analyzer analyzer;
    private static final AstVisitor<Void, Void> CHECK_VISITOR = new AstVisitor<Void, Void>(){

        @Override
        protected Void visitQuery(Query node, Void context) {
            return null;
        }

        @Override
        public Void visitCopyFrom(CopyFrom node, Void context) {
            return null;
        }

        @Override
        protected Void visitNode(Node node, Void context) {
            throw new UnsupportedFeatureException("EXPLAIN is not supported for " + node);
        }
    };

    ExplainStatementAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public ExplainAnalyzedStatement analyze(Explain node, Analysis analysis) {
        AnalyzedStatement subStatement;
        ProfilingContext profilingContext;
        Statement statement = node.getStatement();
        statement.accept(CHECK_VISITOR, null);
        if (node.isAnalyze()) {
            profilingContext = new ProfilingContext(List.of());
            Timer timer = profilingContext.createAndStartTimer(ExplainPlan.Phase.Analyze.name());
            subStatement = this.analyzer.analyzedStatement(statement, analysis);
            profilingContext.stopTimerAndStoreDuration(timer);
        } else {
            profilingContext = null;
            subStatement = this.analyzer.analyzedStatement(statement, analysis);
        }
        String columnName = SqlFormatter.formatSql(node);
        return new ExplainAnalyzedStatement(columnName, subStatement, profilingContext);
    }
}

