/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.profile.ProfilingContext;
import io.crate.types.DataTypes;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExplainAnalyzedStatement
implements AnalyzedStatement,
AnalyzedRelation {
    final AnalyzedStatement statement;
    private final ProfilingContext context;
    private final List<Symbol> outputs;
    private final RelationName relationName = new RelationName(null, "explain");

    ExplainAnalyzedStatement(String columnName, AnalyzedStatement statement, @Nullable ProfilingContext context) {
        ScopedSymbol field = new ScopedSymbol(this.relationName, new ColumnIdent(columnName), context == null ? DataTypes.STRING : DataTypes.UNTYPED_OBJECT);
        this.statement = statement;
        this.context = context;
        this.outputs = List.of(field);
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitExplainStatement(this, context);
    }

    public AnalyzedStatement statement() {
        return this.statement;
    }

    @Nullable
    public ProfilingContext context() {
        return this.context;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation) throws UnsupportedOperationException, ColumnUnknownException {
        throw new UnsupportedOperationException("Cannot use getField on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean isWriteOperation() {
        return false;
    }

    @Override
    public RelationName relationName() {
        return this.relationName;
    }

    @Override
    @Nonnull
    public List<Symbol> outputs() {
        return this.outputs;
    }
}

