/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.sql.tree.CollectionColumnType;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.DefaultTraversalVisitor;
import io.crate.sql.tree.ObjectColumnType;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.util.Locale;

public final class DataTypeAnalyzer
extends DefaultTraversalVisitor<DataType<?>, Void> {
    private static final DataTypeAnalyzer INSTANCE = new DataTypeAnalyzer();

    private DataTypeAnalyzer() {
    }

    public static DataType<?> convert(ColumnType<?> columnType) {
        return (DataType)columnType.accept(INSTANCE, null);
    }

    @Override
    public DataType<?> visitColumnType(ColumnType<?> node, Void context) {
        String typeName = node.name();
        if (typeName == null) {
            return DataTypes.NOT_SUPPORTED;
        }
        return DataTypes.of(typeName.toLowerCase(Locale.ENGLISH), node.parameters());
    }

    @Override
    public DataType<?> visitObjectColumnType(ObjectColumnType<?> node, Void context) {
        ObjectType.Builder builder = ObjectType.builder();
        for (ColumnDefinition<?> columnDefinition : node.nestedColumns()) {
            ColumnType<?> type = columnDefinition.type();
            builder.setInnerType(columnDefinition.ident(), type == null ? DataTypes.UNDEFINED : (DataType)type.accept(this, context));
        }
        return builder.build();
    }

    @Override
    public DataType<?> visitCollectionColumnType(CollectionColumnType<?> node, Void context) {
        DataType innerType = (DataType)node.innerType().accept(this, context);
        return new ArrayType(innerType);
    }
}

