/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCreateTable;
import io.crate.analyze.AnalyzedTableElements;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.TableElementsAnalyzer;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.TableReferenceResolver;
import io.crate.analyze.relations.FieldProvider;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.EnsureNoMatchPredicate;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.TableElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.Function;

public final class CreateTableStatementAnalyzer {
    private final NodeContext nodeCtx;

    public CreateTableStatementAnalyzer(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedCreateTable analyze(CreateTable<Expression> createTable, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        RelationName relationName = RelationName.of(createTable.name().getName(), txnCtx.sessionContext().searchPath().currentSchema());
        relationName.ensureValidForRelationCreation();
        ExpressionAnalyzer exprAnalyzerWithoutFields = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        Function<Expression, Symbol> exprMapper = y -> exprAnalyzerWithFieldsAsString.convert((Expression)y, exprCtx);
        LinkedHashMap<TableElement<Symbol>, TableElement<Expression>> analyzed = new LinkedHashMap<TableElement<Symbol>, TableElement<Expression>>();
        ArrayList<CheckConstraint<Expression>> checkConstraints = new ArrayList<CheckConstraint<Expression>>();
        for (int i = 0; i < createTable.tableElements().size(); ++i) {
            TableElement<Expression> te2 = createTable.tableElements().get(i);
            if (te2 instanceof CheckConstraint) {
                checkConstraints.add((CheckConstraint)te2);
                continue;
            }
            TableElement<Symbol> analyzedTe = null;
            if (te2 instanceof ColumnDefinition) {
                ColumnDefinition def = (ColumnDefinition)te2;
                ArrayList analyzedColumnConstraints = new ArrayList();
                for (int j = 0; j < def.constraints().size(); ++j) {
                    ColumnConstraint<Expression> cc = def.constraints().get(j);
                    if (cc instanceof CheckColumnConstraint) {
                        CheckColumnConstraint columnCheck = (CheckColumnConstraint)cc;
                        checkConstraints.add(new CheckConstraint<Expression>(columnCheck.name(), def.ident(), (Expression)columnCheck.expression(), columnCheck.expressionStr()));
                        continue;
                    }
                    analyzedColumnConstraints.add(cc.map(exprMapper));
                }
                analyzedTe = new ColumnDefinition<Symbol>(def.ident(), null, null, def.type() == null ? null : def.type().map(exprMapper), analyzedColumnConstraints, false, def.isGenerated());
            }
            analyzed.put(analyzedTe == null ? te2.map(exprMapper) : analyzedTe, te2);
        }
        CreateTable<Symbol> analyzedCreateTable = new CreateTable<Symbol>(createTable.name().map(exprMapper), new ArrayList(analyzed.keySet()), createTable.partitionedBy().map(x -> x.map(exprMapper)), createTable.clusteredBy().map(x -> x.map(exprMapper)), createTable.properties().map(x -> exprAnalyzerWithoutFields.convert((Expression)x, exprCtx)), createTable.ifNotExists());
        AnalyzedTableElements<Symbol> analyzedTableElements = TableElementsAnalyzer.analyze(analyzedCreateTable.tableElements(), relationName, null);
        TableReferenceResolver referenceResolver = analyzedTableElements.referenceResolver(relationName);
        ExpressionAnalyzer exprAnalyzerWithReferences = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, referenceResolver, null);
        ArrayList tableElementsWithExpressions = new ArrayList();
        for (int i = 0; i < analyzedCreateTable.tableElements().size(); ++i) {
            TableElement<Symbol> elementSymbol = analyzedCreateTable.tableElements().get(i);
            TableElement elementExpression = (TableElement)analyzed.get(elementSymbol);
            tableElementsWithExpressions.add(elementExpression.mapExpressions(elementSymbol, x -> {
                Symbol symbol = exprAnalyzerWithReferences.convert((Expression)x, exprCtx);
                EnsureNoMatchPredicate.ensureNoMatchPredicate(symbol, "Cannot use MATCH in CREATE TABLE statements");
                return symbol;
            }));
        }
        checkConstraints.stream().map(x -> x.map(y -> exprAnalyzerWithReferences.convert((Expression)y, exprCtx))).forEach(te -> {
            analyzedCreateTable.tableElements().add(te);
            tableElementsWithExpressions.add(te);
            analyzedTableElements.addCheckConstraint(relationName, (CheckConstraint)te);
        });
        AnalyzedTableElements<Symbol> analyzedTableElementsWithExpressions = TableElementsAnalyzer.analyze(tableElementsWithExpressions, relationName, null, false);
        return new AnalyzedCreateTable(relationName, analyzedCreateTable, analyzedTableElements, analyzedTableElementsWithExpressions);
    }
}

