/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.metadata.settings.Validators;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.settings.Setting;

public final class CopyStatementSettings {
    public static final Setting<String> COMPRESSION_SETTING = Setting.simpleString("compression", Validators.stringValidator("compression", "gzip"), Setting.Property.Dynamic);
    public static final Setting<String> OUTPUT_FORMAT_SETTING = Setting.simpleString("format", Validators.stringValidator("format", "json_object", "json_array"), Setting.Property.Dynamic);
    public static final Setting<String> INPUT_FORMAT_SETTING = new Setting<String>("format", "json", s -> s, Validators.stringValidator("format", "json", "csv"), Setting.Property.Dynamic);
    public static final Setting<Boolean> EMPTY_STRING_AS_NULL = Setting.boolSetting("empty_string_as_null", false, Setting.Property.Dynamic);
    public static final Setting<Character> CSV_COLUMN_SEPARATOR = new Setting<Character>("delimiter", String.valueOf(','), value -> {
        if (value.length() != 1) {
            throw new IllegalArgumentException("Invalid CSV fields delimiter: " + value + ". The delimiter must be a single character.");
        }
        return Character.valueOf(value.charAt(0));
    }, Setting.Property.Dynamic);
    public static final Map<String, Setting<?>> OUTPUT_SETTINGS = Map.of(COMPRESSION_SETTING.getKey(), COMPRESSION_SETTING, OUTPUT_FORMAT_SETTING.getKey(), OUTPUT_FORMAT_SETTING);

    private CopyStatementSettings() {
    }

    public static <E extends Enum<E>> E settingAsEnum(Class<E> settingsEnum, String settingValue) {
        if (settingValue == null || settingValue.isEmpty()) {
            return null;
        }
        return Enum.valueOf(settingsEnum, settingValue.toUpperCase(Locale.ENGLISH));
    }
}

