/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.CopyStatementSettings;
import io.crate.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;

public class CopyFromParserProperties
implements Writeable {
    public static final CopyFromParserProperties DEFAULT = CopyFromParserProperties.of(Settings.EMPTY);
    private final boolean emptyStringAsNull;
    private final char columnSeparator;

    public static CopyFromParserProperties of(Settings settings) {
        return new CopyFromParserProperties(CopyStatementSettings.EMPTY_STRING_AS_NULL.get(settings), CopyStatementSettings.CSV_COLUMN_SEPARATOR.get(settings).charValue());
    }

    @VisibleForTesting
    public CopyFromParserProperties(boolean emptyStringAsNull, char columnSeparator) {
        this.emptyStringAsNull = emptyStringAsNull;
        this.columnSeparator = columnSeparator;
    }

    public CopyFromParserProperties(StreamInput in) throws IOException {
        this.emptyStringAsNull = in.readBoolean();
        this.columnSeparator = (char)in.readByte();
    }

    public boolean emptyStringAsNull() {
        return this.emptyStringAsNull;
    }

    public char columnSeparator() {
        return this.columnSeparator;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.emptyStringAsNull);
        out.writeByte((byte)this.columnSeparator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyFromParserProperties that = (CopyFromParserProperties)o;
        return this.emptyStringAsNull == that.emptyStringAsNull && this.columnSeparator == that.columnSeparator;
    }

    public int hashCode() {
        return Objects.hash(this.emptyStringAsNull, Character.valueOf(this.columnSeparator));
    }

    public String toString() {
        return "CopyFromParserProperties{emptyStringAsNull=" + this.emptyStringAsNull + ", columnSeparator=" + this.columnSeparator + "}";
    }
}

