/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCopyFrom;
import io.crate.analyze.AnalyzedCopyFromReturnSummary;
import io.crate.analyze.AnalyzedCopyTo;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.NameFieldProvider;
import io.crate.analyze.relations.TableRelation;
import io.crate.common.collections.Lists2;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.CopyTo;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.List;

class CopyAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    CopyAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    AnalyzedCopyFrom analyzeCopyFrom(CopyFrom<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.resolveTableInfo(node.table().getName(), Operation.INSERT, txnCtx.sessionContext().sessionUser(), txnCtx.sessionContext().searchPath());
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        ExpressionAnalyzer exprAnalyzerWithoutFields = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(this.nodeCtx, RowGranularity.CLUSTER, null, new TableRelation(tableInfo));
        Table<Symbol> table = node.table().map(t -> exprAnalyzerWithFieldsAsString.convert((Expression)t, exprCtx));
        GenericProperties<Symbol> properties = node.properties().map(t -> exprAnalyzerWithoutFields.convert((Expression)t, exprCtx));
        Symbol uri = exprAnalyzerWithoutFields.convert(node.path(), exprCtx);
        if (node.isReturnSummary()) {
            return new AnalyzedCopyFromReturnSummary(tableInfo, table, properties, normalizer.normalize(uri, txnCtx));
        }
        return new AnalyzedCopyFrom(tableInfo, table, properties, normalizer.normalize(uri, txnCtx));
    }

    AnalyzedCopyTo analyzeCopyTo(CopyTo<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        if (!node.directoryUri()) {
            throw new UnsupportedOperationException("Using COPY TO without specifying a DIRECTORY is not supported");
        }
        TableInfo tableInfo = this.schemas.resolveTableInfo(node.table().getName(), Operation.COPY_TO, txnCtx.sessionContext().sessionUser(), txnCtx.sessionContext().searchPath());
        Operation.blockedRaiseException(tableInfo, Operation.READ);
        DocTableRelation tableRelation = new DocTableRelation((DocTableInfo)tableInfo);
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(this.nodeCtx, RowGranularity.CLUSTER, null, tableRelation);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, new NameFieldProvider(tableRelation), null);
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        Symbol uri = expressionAnalyzer.convert(node.targetUri(), exprCtx);
        Table<Symbol> table = node.table().map(x -> exprAnalyzerWithFieldsAsString.convert((Expression)x, exprCtx));
        GenericProperties<Symbol> properties = node.properties().map(x -> expressionAnalyzer.convert((Expression)x, exprCtx));
        List<Symbol> columns = Lists2.map(node.columns(), c -> normalizer.normalize(expressionAnalyzer.convert((Expression)c, exprCtx), txnCtx));
        Symbol whereClause = node.whereClause().map(w -> normalizer.normalize(expressionAnalyzer.convert((Expression)w, exprCtx), txnCtx)).orElse(null);
        return new AnalyzedCopyTo(tableInfo, table, normalizer.normalize(uri, txnCtx), properties, columns, whereClause);
    }
}

