/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.Settings;

public class BoundRestoreSnapshot {
    private final String repository;
    private final String snapshot;
    private final HashSet<RestoreTableInfo> restoreTables;
    private final Settings settings;

    public BoundRestoreSnapshot(String repository, String snapshot, HashSet<RestoreTableInfo> restoreTables, Settings settings) {
        this.repository = repository;
        this.snapshot = snapshot;
        this.restoreTables = restoreTables;
        this.settings = settings;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public String repository() {
        return this.repository;
    }

    public Settings settings() {
        return this.settings;
    }

    public Set<RestoreTableInfo> restoreTables() {
        return this.restoreTables;
    }

    public static class RestoreTableInfo {
        private final RelationName relationName;
        private final PartitionName partitionName;
        private final String partitionTemplate;

        public RestoreTableInfo(RelationName relationName, @Nullable PartitionName partitionName) {
            this.relationName = relationName;
            this.partitionName = partitionName;
            this.partitionTemplate = PartitionName.templateName(relationName.schema(), this.tableIdent().name());
        }

        public RelationName tableIdent() {
            return this.relationName;
        }

        @Nullable
        public PartitionName partitionName() {
            return this.partitionName;
        }

        public boolean hasPartitionInfo() {
            return this.partitionName != null;
        }

        public String partitionTemplate() {
            return this.partitionTemplate;
        }
    }
}

