/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedTableElements;
import io.crate.analyze.TableParameter;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class BoundCreateTable {
    private final RelationName relationName;
    private final AnalyzedTableElements<Object> analyzedTableElements;
    private final TableParameter tableParameter;
    private final ColumnIdent routingColumn;
    private final boolean noOp;
    private final boolean ifNotExists;
    private Map<String, Object> mapping;

    public BoundCreateTable(RelationName relationName, AnalyzedTableElements<Object> tableElements, TableParameter tableParameter, @Nullable ColumnIdent routingColumn, boolean ifNotExists, Schemas schemas) {
        relationName.ensureValidForRelationCreation();
        boolean tableExists = schemas.tableExists(relationName);
        boolean viewExists = schemas.viewExists(relationName);
        if (ifNotExists && !viewExists) {
            this.noOp = tableExists;
        } else {
            if (tableExists || viewExists) {
                throw new RelationAlreadyExists(relationName);
            }
            this.noOp = false;
        }
        this.ifNotExists = ifNotExists;
        this.relationName = relationName;
        this.analyzedTableElements = tableElements;
        this.tableParameter = tableParameter;
        this.routingColumn = routingColumn != null && !routingColumn.name().equalsIgnoreCase("_id") ? routingColumn : null;
    }

    public boolean noOp() {
        return this.noOp;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public List<List<String>> partitionedBy() {
        return this.analyzedTableElements().partitionedBy();
    }

    public boolean isPartitioned() {
        return !this.analyzedTableElements().partitionedByColumns.isEmpty();
    }

    @Nullable
    public String templateName() {
        if (this.isPartitioned()) {
            return PartitionName.templateName(this.tableIdent().schema(), this.tableIdent().name());
        }
        return null;
    }

    @Nullable
    public String templatePrefix() {
        if (this.isPartitioned()) {
            return PartitionName.templatePrefix(this.tableIdent().schema(), this.tableIdent().name());
        }
        return null;
    }

    Map<String, Object> mappingProperties() {
        return (Map)this.mapping().get("properties");
    }

    public Collection<String> primaryKeys() {
        return AnalyzedTableElements.primaryKeys(this.analyzedTableElements);
    }

    public Collection<String> notNullColumns() {
        return AnalyzedTableElements.notNullColumns(this.analyzedTableElements);
    }

    public Map<String, Object> mapping() {
        if (this.mapping == null) {
            this.mapping = AnalyzedTableElements.toMapping(this.analyzedTableElements);
            Map metaMap = (Map)this.mapping.get("_meta");
            if (this.routingColumn != null) {
                metaMap.put("routing", this.routingColumn.fqn());
            }
            this.mapping.putAll(this.tableParameter.mappings());
        }
        return this.mapping;
    }

    public RelationName tableIdent() {
        return this.relationName;
    }

    boolean hasColumnDefinition(ColumnIdent columnIdent) {
        return this.analyzedTableElements().columnIdents().contains(columnIdent) || columnIdent.name().equalsIgnoreCase("_id");
    }

    AnalyzedTableElements<Object> analyzedTableElements() {
        return this.analyzedTableElements;
    }

    public TableParameter tableParameter() {
        return this.tableParameter;
    }
}

