/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.AlterTableAddColumnAnalyzer;
import io.crate.analyze.AlterTableAnalyzer;
import io.crate.analyze.AlterTableRerouteAnalyzer;
import io.crate.analyze.Analysis;
import io.crate.analyze.AnalyzedAnalyze;
import io.crate.analyze.AnalyzedBegin;
import io.crate.analyze.AnalyzedCommit;
import io.crate.analyze.AnalyzedDiscard;
import io.crate.analyze.AnalyzedDropTable;
import io.crate.analyze.AnalyzedDropUser;
import io.crate.analyze.AnalyzedGCDanglingArtifacts;
import io.crate.analyze.AnalyzedRerouteRetryFailed;
import io.crate.analyze.AnalyzedSetSessionAuthorizationStatement;
import io.crate.analyze.AnalyzedSetTransaction;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.CopyAnalyzer;
import io.crate.analyze.CreateAnalyzerStatementAnalyzer;
import io.crate.analyze.CreateBlobTableAnalyzer;
import io.crate.analyze.CreateFunctionAnalyzer;
import io.crate.analyze.CreateRepositoryAnalyzer;
import io.crate.analyze.CreateSnapshotAnalyzer;
import io.crate.analyze.CreateTableStatementAnalyzer;
import io.crate.analyze.DeallocateAnalyzer;
import io.crate.analyze.DecommissionNodeAnalyzer;
import io.crate.analyze.DeleteAnalyzer;
import io.crate.analyze.DropAnalyzerStatementAnalyzer;
import io.crate.analyze.DropCheckConstraintAnalyzer;
import io.crate.analyze.DropFunctionAnalyzer;
import io.crate.analyze.DropRepositoryAnalyzer;
import io.crate.analyze.DropSnapshotAnalyzer;
import io.crate.analyze.DropTableAnalyzer;
import io.crate.analyze.ExplainStatementAnalyzer;
import io.crate.analyze.InsertAnalyzer;
import io.crate.analyze.KillAnalyzer;
import io.crate.analyze.OptimizeTableAnalyzer;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.PrivilegesAnalyzer;
import io.crate.analyze.RefreshTableAnalyzer;
import io.crate.analyze.ResetStatementAnalyzer;
import io.crate.analyze.RestoreSnapshotAnalyzer;
import io.crate.analyze.SetStatementAnalyzer;
import io.crate.analyze.ShowStatementAnalyzer;
import io.crate.analyze.SwapTableAnalyzer;
import io.crate.analyze.UpdateAnalyzer;
import io.crate.analyze.UserAnalyzer;
import io.crate.analyze.ViewAnalyzer;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.auth.user.UserManager;
import io.crate.execution.ddl.RepositoryService;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.sql.tree.AlterBlobTable;
import io.crate.sql.tree.AlterClusterRerouteRetryFailed;
import io.crate.sql.tree.AlterTable;
import io.crate.sql.tree.AlterTableAddColumn;
import io.crate.sql.tree.AlterTableOpenClose;
import io.crate.sql.tree.AlterTableRename;
import io.crate.sql.tree.AlterTableReroute;
import io.crate.sql.tree.AlterUser;
import io.crate.sql.tree.AnalyzeStatement;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.BeginStatement;
import io.crate.sql.tree.CommitStatement;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.CopyTo;
import io.crate.sql.tree.CreateAnalyzer;
import io.crate.sql.tree.CreateBlobTable;
import io.crate.sql.tree.CreateFunction;
import io.crate.sql.tree.CreateRepository;
import io.crate.sql.tree.CreateSnapshot;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.CreateUser;
import io.crate.sql.tree.CreateView;
import io.crate.sql.tree.DeallocateStatement;
import io.crate.sql.tree.DecommissionNodeStatement;
import io.crate.sql.tree.Delete;
import io.crate.sql.tree.DenyPrivilege;
import io.crate.sql.tree.DiscardStatement;
import io.crate.sql.tree.DropAnalyzer;
import io.crate.sql.tree.DropBlobTable;
import io.crate.sql.tree.DropCheckConstraint;
import io.crate.sql.tree.DropFunction;
import io.crate.sql.tree.DropRepository;
import io.crate.sql.tree.DropSnapshot;
import io.crate.sql.tree.DropTable;
import io.crate.sql.tree.DropUser;
import io.crate.sql.tree.DropView;
import io.crate.sql.tree.Explain;
import io.crate.sql.tree.GCDanglingArtifacts;
import io.crate.sql.tree.GrantPrivilege;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.KillStatement;
import io.crate.sql.tree.OptimizeStatement;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.RefreshStatement;
import io.crate.sql.tree.ResetStatement;
import io.crate.sql.tree.RestoreSnapshot;
import io.crate.sql.tree.RevokePrivilege;
import io.crate.sql.tree.SetSessionAuthorizationStatement;
import io.crate.sql.tree.SetStatement;
import io.crate.sql.tree.SetTransactionStatement;
import io.crate.sql.tree.ShowColumns;
import io.crate.sql.tree.ShowCreateTable;
import io.crate.sql.tree.ShowSchemas;
import io.crate.sql.tree.ShowSessionParameter;
import io.crate.sql.tree.ShowTables;
import io.crate.sql.tree.ShowTransaction;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.SwapTable;
import io.crate.sql.tree.Update;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.analysis.AnalysisRegistry;

@Singleton
public class Analyzer {
    private final AnalyzerDispatcher dispatcher = new AnalyzerDispatcher();
    private final RelationAnalyzer relationAnalyzer;
    private final DropTableAnalyzer dropTableAnalyzer;
    private final DropCheckConstraintAnalyzer dropCheckConstraintAnalyzer;
    private final CreateTableStatementAnalyzer createTableStatementAnalyzer;
    private final ExplainStatementAnalyzer explainStatementAnalyzer;
    private final ShowStatementAnalyzer showStatementAnalyzer;
    private final CreateBlobTableAnalyzer createBlobTableAnalyzer;
    private final CreateAnalyzerStatementAnalyzer createAnalyzerStatementAnalyzer;
    private final DropAnalyzerStatementAnalyzer dropAnalyzerStatementAnalyzer;
    private final UserManager userManager;
    private final RefreshTableAnalyzer refreshTableAnalyzer;
    private final OptimizeTableAnalyzer optimizeTableAnalyzer;
    private final AlterTableAnalyzer alterTableAnalyzer;
    private final AlterTableAddColumnAnalyzer alterTableAddColumnAnalyzer;
    private final InsertAnalyzer insertAnalyzer;
    private final CopyAnalyzer copyAnalyzer;
    private final UpdateAnalyzer updateAnalyzer;
    private final DeleteAnalyzer deleteAnalyzer;
    private final DropRepositoryAnalyzer dropRepositoryAnalyzer;
    private final CreateRepositoryAnalyzer createRepositoryAnalyzer;
    private final DropSnapshotAnalyzer dropSnapshotAnalyzer;
    private final CreateSnapshotAnalyzer createSnapshotAnalyzer;
    private final RestoreSnapshotAnalyzer restoreSnapshotAnalyzer;
    private final CreateFunctionAnalyzer createFunctionAnalyzer;
    private final DropFunctionAnalyzer dropFunctionAnalyzer;
    private final PrivilegesAnalyzer privilegesAnalyzer;
    private final AlterTableRerouteAnalyzer alterTableRerouteAnalyzer;
    private final UserAnalyzer userAnalyzer;
    private final ViewAnalyzer viewAnalyzer;
    private final SwapTableAnalyzer swapTableAnalyzer;
    private final DecommissionNodeAnalyzer decommissionNodeAnalyzer;
    private final KillAnalyzer killAnalyzer;
    private final SetStatementAnalyzer setStatementAnalyzer;
    private final ResetStatementAnalyzer resetStatementAnalyzer;

    @Inject
    public Analyzer(Schemas schemas, NodeContext nodeCtx, RelationAnalyzer relationAnalyzer, ClusterService clusterService, AnalysisRegistry analysisRegistry, RepositoryService repositoryService, UserManager userManager, SessionSettingRegistry sessionSettingRegistry) {
        this.relationAnalyzer = relationAnalyzer;
        this.dropTableAnalyzer = new DropTableAnalyzer(clusterService, schemas);
        this.dropCheckConstraintAnalyzer = new DropCheckConstraintAnalyzer(schemas);
        this.userManager = userManager;
        this.createTableStatementAnalyzer = new CreateTableStatementAnalyzer(nodeCtx);
        this.alterTableAnalyzer = new AlterTableAnalyzer(schemas, nodeCtx);
        this.alterTableAddColumnAnalyzer = new AlterTableAddColumnAnalyzer(schemas, nodeCtx);
        this.swapTableAnalyzer = new SwapTableAnalyzer(nodeCtx, schemas);
        this.viewAnalyzer = new ViewAnalyzer(relationAnalyzer, schemas);
        this.explainStatementAnalyzer = new ExplainStatementAnalyzer(this);
        this.showStatementAnalyzer = new ShowStatementAnalyzer(this, schemas, sessionSettingRegistry);
        this.updateAnalyzer = new UpdateAnalyzer(nodeCtx, relationAnalyzer);
        this.deleteAnalyzer = new DeleteAnalyzer(nodeCtx, relationAnalyzer);
        this.insertAnalyzer = new InsertAnalyzer(nodeCtx, schemas, relationAnalyzer);
        this.optimizeTableAnalyzer = new OptimizeTableAnalyzer(schemas, nodeCtx);
        this.createRepositoryAnalyzer = new CreateRepositoryAnalyzer(repositoryService, nodeCtx);
        this.dropRepositoryAnalyzer = new DropRepositoryAnalyzer(repositoryService);
        this.createSnapshotAnalyzer = new CreateSnapshotAnalyzer(repositoryService, nodeCtx);
        this.dropSnapshotAnalyzer = new DropSnapshotAnalyzer(repositoryService);
        this.userAnalyzer = new UserAnalyzer(nodeCtx);
        this.createBlobTableAnalyzer = new CreateBlobTableAnalyzer(schemas, nodeCtx);
        this.createFunctionAnalyzer = new CreateFunctionAnalyzer(nodeCtx);
        this.dropFunctionAnalyzer = new DropFunctionAnalyzer();
        this.refreshTableAnalyzer = new RefreshTableAnalyzer(nodeCtx, schemas);
        this.restoreSnapshotAnalyzer = new RestoreSnapshotAnalyzer(repositoryService, nodeCtx);
        FulltextAnalyzerResolver fulltextAnalyzerResolver = new FulltextAnalyzerResolver(clusterService, analysisRegistry);
        this.createAnalyzerStatementAnalyzer = new CreateAnalyzerStatementAnalyzer(fulltextAnalyzerResolver, nodeCtx);
        this.dropAnalyzerStatementAnalyzer = new DropAnalyzerStatementAnalyzer(fulltextAnalyzerResolver);
        this.decommissionNodeAnalyzer = new DecommissionNodeAnalyzer(nodeCtx);
        this.killAnalyzer = new KillAnalyzer(nodeCtx);
        this.alterTableRerouteAnalyzer = new AlterTableRerouteAnalyzer(nodeCtx, schemas);
        this.privilegesAnalyzer = new PrivilegesAnalyzer(userManager.isEnabled(), schemas);
        this.copyAnalyzer = new CopyAnalyzer(schemas, nodeCtx);
        this.setStatementAnalyzer = new SetStatementAnalyzer(nodeCtx);
        this.resetStatementAnalyzer = new ResetStatementAnalyzer(nodeCtx);
    }

    public AnalyzedStatement analyze(Statement statement, SessionContext sessionContext, ParamTypeHints paramTypeHints) {
        AnalyzedStatement analyzedStatement = statement.accept(this.dispatcher, new Analysis(new CoordinatorTxnCtx(sessionContext), paramTypeHints));
        this.userManager.getAccessControl(sessionContext).ensureMayExecute(analyzedStatement);
        return analyzedStatement;
    }

    AnalyzedStatement analyzedStatement(Statement statement, Analysis analysis) {
        AnalyzedStatement analyzedStatement = statement.accept(this.dispatcher, analysis);
        assert (analyzedStatement != null) : "analyzed statement must not be null";
        return analyzedStatement;
    }

    private class AnalyzerDispatcher
    extends AstVisitor<AnalyzedStatement, Analysis> {
        private AnalyzerDispatcher() {
        }

        @Override
        public AnalyzedStatement visitAlterBlobTable(AlterBlobTable<?> node, Analysis context) {
            return Analyzer.this.alterTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitAlterClusterDecommissionNode(DecommissionNodeStatement<?> node, Analysis context) {
            return Analyzer.this.decommissionNodeAnalyzer.analyze(node, context.transactionContext(), context.paramTypeHints());
        }

        @Override
        public AnalyzedStatement visitAlterClusterRerouteRetryFailed(AlterClusterRerouteRetryFailed node, Analysis context) {
            return new AnalyzedRerouteRetryFailed();
        }

        @Override
        public AnalyzedStatement visitAlterTable(AlterTable<?> node, Analysis context) {
            return Analyzer.this.alterTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitDropCheckConstraint(DropCheckConstraint<?> node, Analysis context) {
            return Analyzer.this.dropCheckConstraintAnalyzer.analyze(node.table(), node.name(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitAlterTableAddColumnStatement(AlterTableAddColumn<?> node, Analysis context) {
            return Analyzer.this.alterTableAddColumnAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitAlterTableOpenClose(AlterTableOpenClose<?> node, Analysis context) {
            return Analyzer.this.alterTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitAlterTableRename(AlterTableRename<?> node, Analysis context) {
            return Analyzer.this.alterTableAnalyzer.analyze(node, context.sessionContext());
        }

        @Override
        public AnalyzedStatement visitAlterTableReroute(AlterTableReroute<?> node, Analysis context) {
            return Analyzer.this.alterTableRerouteAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitAlterUser(AlterUser<?> node, Analysis context) {
            return Analyzer.this.userAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitAnalyze(AnalyzeStatement analyzeStatement, Analysis analysis) {
            return new AnalyzedAnalyze();
        }

        @Override
        public AnalyzedStatement visitBegin(BeginStatement node, Analysis context) {
            return new AnalyzedBegin();
        }

        @Override
        public AnalyzedStatement visitCommit(CommitStatement node, Analysis context) {
            return new AnalyzedCommit();
        }

        @Override
        public AnalyzedStatement visitCopyFrom(CopyFrom<?> node, Analysis context) {
            return Analyzer.this.copyAnalyzer.analyzeCopyFrom(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitCopyTo(CopyTo<?> node, Analysis context) {
            return Analyzer.this.copyAnalyzer.analyzeCopyTo(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitCreateAnalyzer(CreateAnalyzer<?> node, Analysis context) {
            return Analyzer.this.createAnalyzerStatementAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitCreateBlobTable(CreateBlobTable<?> node, Analysis context) {
            return Analyzer.this.createBlobTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitCreateFunction(CreateFunction<?> node, Analysis context) {
            return Analyzer.this.createFunctionAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext(), context.sessionContext().searchPath());
        }

        @Override
        public AnalyzedStatement visitCreateRepository(CreateRepository node, Analysis context) {
            return Analyzer.this.createRepositoryAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitCreateSnapshot(CreateSnapshot<?> node, Analysis context) {
            return Analyzer.this.createSnapshotAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitCreateTable(CreateTable node, Analysis analysis) {
            return Analyzer.this.createTableStatementAnalyzer.analyze(node, analysis.paramTypeHints(), analysis.transactionContext());
        }

        @Override
        public AnalyzedStatement visitCreateUser(CreateUser<?> node, Analysis context) {
            return Analyzer.this.userAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitCreateView(CreateView node, Analysis context) {
            return Analyzer.this.viewAnalyzer.analyze(node, context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitDeallocateStatement(DeallocateStatement node, Analysis context) {
            return DeallocateAnalyzer.analyze(node);
        }

        @Override
        public AnalyzedStatement visitDiscard(DiscardStatement discardStatement, Analysis context) {
            return new AnalyzedDiscard(discardStatement.target());
        }

        @Override
        public AnalyzedStatement visitDelete(Delete node, Analysis analysis) {
            return Analyzer.this.deleteAnalyzer.analyze(node, analysis.paramTypeHints(), analysis.transactionContext());
        }

        @Override
        public AnalyzedStatement visitDenyPrivilege(DenyPrivilege node, Analysis context) {
            return Analyzer.this.privilegesAnalyzer.analyzeDeny(node, context.sessionContext().sessionUser(), context.sessionContext().searchPath());
        }

        @Override
        public AnalyzedStatement visitDropAnalyzer(DropAnalyzer node, Analysis context) {
            return Analyzer.this.dropAnalyzerStatementAnalyzer.analyze(node.name());
        }

        @Override
        public AnalyzedStatement visitDropBlobTable(DropBlobTable<?> node, Analysis context) {
            return Analyzer.this.dropTableAnalyzer.analyze(node, context.sessionContext());
        }

        @Override
        public AnalyzedStatement visitDropFunction(DropFunction node, Analysis context) {
            return Analyzer.this.dropFunctionAnalyzer.analyze(node, context.sessionContext().searchPath());
        }

        @Override
        public AnalyzedStatement visitDropRepository(DropRepository node, Analysis context) {
            return Analyzer.this.dropRepositoryAnalyzer.analyze(node);
        }

        @Override
        public AnalyzedStatement visitDropSnapshot(DropSnapshot node, Analysis context) {
            return Analyzer.this.dropSnapshotAnalyzer.analyze(node);
        }

        @Override
        public AnalyzedDropTable visitDropTable(DropTable<?> node, Analysis context) {
            return Analyzer.this.dropTableAnalyzer.analyze(node, context.sessionContext());
        }

        @Override
        public AnalyzedStatement visitDropUser(DropUser node, Analysis context) {
            return new AnalyzedDropUser(node.name(), node.ifExists());
        }

        @Override
        public AnalyzedStatement visitDropView(DropView node, Analysis context) {
            return Analyzer.this.viewAnalyzer.analyze(node, context.transactionContext());
        }

        @Override
        protected AnalyzedStatement visitExplain(Explain node, Analysis context) {
            return Analyzer.this.explainStatementAnalyzer.analyze(node, context);
        }

        @Override
        public AnalyzedStatement visitGCDanglingArtifacts(GCDanglingArtifacts gcDanglingArtifacts, Analysis context) {
            return AnalyzedGCDanglingArtifacts.INSTANCE;
        }

        @Override
        public AnalyzedStatement visitGrantPrivilege(GrantPrivilege node, Analysis context) {
            return Analyzer.this.privilegesAnalyzer.analyzeGrant(node, context.sessionContext().sessionUser(), context.sessionContext().searchPath());
        }

        @Override
        public AnalyzedStatement visitInsert(Insert<?> node, Analysis analysis) {
            return Analyzer.this.insertAnalyzer.analyze(node, analysis.paramTypeHints(), analysis.transactionContext());
        }

        @Override
        public AnalyzedStatement visitKillStatement(KillStatement<?> node, Analysis context) {
            return Analyzer.this.killAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitOptimizeStatement(OptimizeStatement<?> node, Analysis context) {
            return Analyzer.this.optimizeTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        protected AnalyzedStatement visitQuery(Query node, Analysis context) {
            return Analyzer.this.relationAnalyzer.analyze(node, context.transactionContext(), context.paramTypeHints());
        }

        @Override
        public AnalyzedStatement visitRefreshStatement(RefreshStatement<?> node, Analysis context) {
            return Analyzer.this.refreshTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitResetStatement(ResetStatement<?> node, Analysis context) {
            return Analyzer.this.resetStatementAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitRestoreSnapshot(RestoreSnapshot<?> node, Analysis context) {
            return Analyzer.this.restoreSnapshotAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitRevokePrivilege(RevokePrivilege node, Analysis context) {
            return Analyzer.this.privilegesAnalyzer.analyzeRevoke(node, context.sessionContext().sessionUser(), context.sessionContext().searchPath());
        }

        @Override
        public AnalyzedStatement visitSetStatement(SetStatement<?> node, Analysis context) {
            return Analyzer.this.setStatementAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        @Override
        public AnalyzedStatement visitSetSessionAuthorizationStatement(SetSessionAuthorizationStatement node, Analysis context) {
            return new AnalyzedSetSessionAuthorizationStatement(node.user(), node.scope());
        }

        @Override
        public AnalyzedStatement visitSetTransaction(SetTransactionStatement setTransaction, Analysis analysis) {
            return new AnalyzedSetTransaction(setTransaction.transactionModes());
        }

        @Override
        protected AnalyzedStatement visitShowColumns(ShowColumns node, Analysis context) {
            CoordinatorTxnCtx coordinatorTxnCtx = context.transactionContext();
            Query query = Analyzer.this.showStatementAnalyzer.rewriteShowColumns(node, coordinatorTxnCtx.sessionContext().searchPath().currentSchema());
            return Analyzer.this.relationAnalyzer.analyze(query, coordinatorTxnCtx, context.paramTypeHints());
        }

        @Override
        public AnalyzedStatement visitShowCreateTable(ShowCreateTable<?> node, Analysis context) {
            return Analyzer.this.showStatementAnalyzer.analyzeShowCreateTable(node.table(), context);
        }

        @Override
        protected AnalyzedStatement visitShowSchemas(ShowSchemas node, Analysis context) {
            Query query = Analyzer.this.showStatementAnalyzer.rewriteShowSchemas(node);
            return Analyzer.this.relationAnalyzer.analyze(query, context.transactionContext(), context.paramTypeHints());
        }

        @Override
        public AnalyzedStatement visitShowSessionParameter(ShowSessionParameter node, Analysis context) {
            Analyzer.this.showStatementAnalyzer.validateSessionSetting(node.parameter());
            Query query = Analyzer.this.showStatementAnalyzer.rewriteShowSessionParameter(node);
            return Analyzer.this.relationAnalyzer.analyze(query, context.transactionContext(), context.paramTypeHints());
        }

        @Override
        protected AnalyzedStatement visitShowTables(ShowTables node, Analysis context) {
            Query query = Analyzer.this.showStatementAnalyzer.rewriteShowTables(node);
            return Analyzer.this.relationAnalyzer.analyze(query, context.transactionContext(), context.paramTypeHints());
        }

        @Override
        public AnalyzedStatement visitShowTransaction(ShowTransaction showTransaction, Analysis context) {
            return Analyzer.this.showStatementAnalyzer.analyzeShowTransaction(context);
        }

        @Override
        public AnalyzedStatement visitSwapTable(SwapTable<?> node, Analysis analysis) {
            return Analyzer.this.swapTableAnalyzer.analyze(node, analysis.transactionContext(), analysis.paramTypeHints());
        }

        @Override
        public AnalyzedStatement visitUpdate(Update node, Analysis analysis) {
            return Analyzer.this.updateAnalyzer.analyze(node, analysis.paramTypeHints(), analysis.transactionContext());
        }
    }
}

