/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Reference;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class AnalyzedUpdateStatement
implements AnalyzedStatement {
    private final AbstractTableRelation<?> table;
    private final Map<Reference, Symbol> assignmentByTargetCol;
    private final Symbol query;
    @Nullable
    private final List<Symbol> returnValues;

    public AnalyzedUpdateStatement(AbstractTableRelation<?> table, Map<Reference, Symbol> assignmentByTargetCol, Symbol query, @Nullable List<Symbol> returnValues) {
        this.table = table;
        this.assignmentByTargetCol = assignmentByTargetCol;
        this.query = query;
        this.returnValues = returnValues;
    }

    public AbstractTableRelation<?> table() {
        return this.table;
    }

    public Map<Reference, Symbol> assignmentByTargetCol() {
        return this.assignmentByTargetCol;
    }

    public Symbol query() {
        return this.query;
    }

    @Override
    @Nullable
    public List<Symbol> outputs() {
        return this.returnValues;
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> visitor, C context) {
        return visitor.visitAnalyzedUpdateStatement(this, context);
    }

    @Override
    public boolean isWriteOperation() {
        return true;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        consumer.accept(this.query);
        for (Symbol sourceExpr : this.assignmentByTargetCol.values()) {
            consumer.accept(sourceExpr);
        }
        if (this.returnValues != null) {
            for (Symbol returningSymbol : this.returnValues) {
                consumer.accept(returningSymbol);
            }
        }
    }
}

