/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedColumnDefinition;
import io.crate.analyze.expressions.TableReferenceResolver;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.scalar.cast.CastFunctionResolver;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.RefVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.CheckConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.Settings;

public class AnalyzedTableElements<T> {
    public List<AnalyzedColumnDefinition<T>> partitionedByColumns = new ArrayList<AnalyzedColumnDefinition<T>>();
    private List<AnalyzedColumnDefinition<T>> columns = new ArrayList<AnalyzedColumnDefinition<T>>();
    private Set<ColumnIdent> columnIdents = new HashSet<ColumnIdent>();
    private Map<ColumnIdent, DataType> columnTypes = new HashMap<ColumnIdent, DataType>();
    private Set<String> primaryKeys;
    private Set<String> notNullColumns;
    private Map<String, String> checkConstraints = new LinkedHashMap<String, String>();
    private List<List<String>> partitionedBy;
    private int numGeneratedColumns = 0;
    private List<T> additionalPrimaryKeys = new ArrayList<T>();
    private Map<T, Set<String>> copyToMap = new HashMap<T, Set<String>>();

    public AnalyzedTableElements() {
    }

    private AnalyzedTableElements(List<AnalyzedColumnDefinition<T>> partitionedByColumns, List<AnalyzedColumnDefinition<T>> columns, Set<ColumnIdent> columnIdents, Map<ColumnIdent, DataType> columnTypes, Set<String> primaryKeys, Set<String> notNullColumns, Map<String, String> checkConstraints, List<List<String>> partitionedBy, int numGeneratedColumns, List<T> additionalPrimaryKeys, Map<T, Set<String>> copyToMap) {
        this.partitionedByColumns = partitionedByColumns;
        this.columns = columns;
        this.columnIdents = columnIdents;
        this.columnTypes = columnTypes;
        this.primaryKeys = primaryKeys;
        this.notNullColumns = notNullColumns;
        this.checkConstraints = checkConstraints;
        this.partitionedBy = partitionedBy;
        this.numGeneratedColumns = numGeneratedColumns;
        this.additionalPrimaryKeys = additionalPrimaryKeys;
        this.copyToMap = copyToMap;
    }

    static Map<String, Object> toMapping(AnalyzedTableElements<Object> elements) {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        HashMap<String, Object> meta = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>(elements.columns.size());
        HashMap<String, String> generatedColumns = new HashMap<String, String>();
        HashMap<String, Map<String, Object>> indicesMap = new HashMap<String, Map<String, Object>>();
        for (AnalyzedColumnDefinition<Object> analyzedColumnDefinition : elements.columns) {
            properties.put(analyzedColumnDefinition.name(), AnalyzedColumnDefinition.toMapping(analyzedColumnDefinition));
            if (analyzedColumnDefinition.isIndexColumn()) {
                indicesMap.put(analyzedColumnDefinition.name(), analyzedColumnDefinition.toMetaIndicesMapping());
            }
            AnalyzedTableElements.addToGeneratedColumns("", analyzedColumnDefinition, generatedColumns);
        }
        if (!elements.partitionedByColumns.isEmpty()) {
            meta.put("partitioned_by", elements.partitionedBy());
        }
        if (!indicesMap.isEmpty()) {
            meta.put("indices", indicesMap);
        }
        if (!AnalyzedTableElements.primaryKeys(elements).isEmpty()) {
            meta.put("primary_keys", AnalyzedTableElements.primaryKeys(elements));
        }
        if (!generatedColumns.isEmpty()) {
            meta.put("generated_columns", generatedColumns);
        }
        if (!AnalyzedTableElements.notNullColumns(elements).isEmpty()) {
            HashMap<String, Set<String>> constraints = new HashMap<String, Set<String>>();
            constraints.put("not_null", AnalyzedTableElements.notNullColumns(elements));
            meta.put("constraints", constraints);
        }
        if (!elements.checkConstraints.isEmpty()) {
            meta.put("check_constraints", elements.checkConstraints);
        }
        mapping.put("_meta", meta);
        mapping.put("properties", properties);
        return mapping;
    }

    private static void addToGeneratedColumns(String columnPrefix, AnalyzedColumnDefinition<Object> column, Map<String, String> generatedColumns) {
        String generatedExpression = column.formattedGeneratedExpression();
        if (generatedExpression != null) {
            generatedColumns.put(columnPrefix + column.name(), generatedExpression);
        }
        for (AnalyzedColumnDefinition<Object> child : column.children()) {
            AnalyzedTableElements.addToGeneratedColumns(columnPrefix + column.name() + ".", child, generatedColumns);
        }
    }

    public <U> AnalyzedTableElements<U> map(Function<? super T, ? extends U> mapper) {
        ArrayList<U> additionalPrimaryKeys = new ArrayList<U>(this.additionalPrimaryKeys.size());
        for (Object p : this.additionalPrimaryKeys) {
            additionalPrimaryKeys.add(mapper.apply(p));
        }
        HashMap<U, Set> copyToMap = new HashMap<U, Set>(this.copyToMap.size());
        for (Map.Entry entry : this.copyToMap.entrySet()) {
            copyToMap.put(mapper.apply(entry.getKey()), (Set)entry.getValue());
        }
        ArrayList<AnalyzedColumnDefinition<T>> partitionedByColumns = new ArrayList<AnalyzedColumnDefinition<T>>(this.partitionedByColumns.size());
        for (AnalyzedColumnDefinition analyzedColumnDefinition : this.partitionedByColumns) {
            partitionedByColumns.add(analyzedColumnDefinition.map(mapper));
        }
        ArrayList<AnalyzedColumnDefinition<T>> arrayList = new ArrayList<AnalyzedColumnDefinition<T>>(this.columns.size());
        for (AnalyzedColumnDefinition analyzedColumnDefinition : this.columns) {
            arrayList.add(analyzedColumnDefinition.map(mapper));
        }
        return new AnalyzedTableElements<T>(partitionedByColumns, arrayList, this.columnIdents, this.columnTypes, this.primaryKeys, this.notNullColumns, this.checkConstraints, this.partitionedBy, this.numGeneratedColumns, additionalPrimaryKeys, copyToMap);
    }

    public List<List<String>> partitionedBy() {
        if (this.partitionedBy == null) {
            this.partitionedBy = new ArrayList<List<String>>(this.partitionedByColumns.size());
            for (AnalyzedColumnDefinition<T> partitionedByColumn : this.partitionedByColumns) {
                this.partitionedBy.add(List.of(partitionedByColumn.ident().fqn(), partitionedByColumn.typeNameForESMapping()));
            }
        }
        return this.partitionedBy;
    }

    private void expandColumnIdents() {
        for (AnalyzedColumnDefinition<T> column : this.columns) {
            this.expandColumn(column);
        }
    }

    private void expandColumn(AnalyzedColumnDefinition<T> column) {
        if (column.isIndexColumn()) {
            this.columnIdents.remove(column.ident());
            return;
        }
        this.columnIdents.add(column.ident());
        this.columnTypes.put(column.ident(), column.dataType());
        for (AnalyzedColumnDefinition<T> child : column.children()) {
            this.expandColumn(child);
        }
    }

    static Set<String> notNullColumns(AnalyzedTableElements<Object> elements) {
        if (elements.notNullColumns == null) {
            elements.notNullColumns = new HashSet<String>();
            for (AnalyzedColumnDefinition<Object> analyzedColumnDefinition : elements.columns) {
                AnalyzedTableElements.addNotNullFromChildren(analyzedColumnDefinition, elements);
            }
        }
        return elements.notNullColumns;
    }

    private static void addNotNullFromChildren(AnalyzedColumnDefinition<Object> parentColumn, AnalyzedTableElements<Object> elements) {
        LinkedList childColumns = new LinkedList();
        childColumns.add(parentColumn);
        while (!childColumns.isEmpty()) {
            AnalyzedColumnDefinition column = (AnalyzedColumnDefinition)childColumns.remove();
            String fqn = column.ident().fqn();
            if (column.hasNotNullConstraint() && !AnalyzedTableElements.primaryKeys(elements).contains(fqn)) {
                elements.notNullColumns.add(fqn);
            }
            childColumns.addAll(column.children());
        }
    }

    public static Set<String> primaryKeys(AnalyzedTableElements<Object> elements) {
        if (elements.primaryKeys == null) {
            elements.primaryKeys = new LinkedHashSet<String>();
            for (Object t : elements.additionalPrimaryKeys) {
                String pkAsString = t.toString();
                AnalyzedTableElements.checkPrimaryKeyAlreadyDefined(elements.primaryKeys, pkAsString);
                elements.primaryKeys.add(pkAsString);
            }
            for (AnalyzedColumnDefinition analyzedColumnDefinition : elements.columns) {
                elements.addPrimaryKeys(elements.primaryKeys, analyzedColumnDefinition);
            }
        }
        return elements.primaryKeys;
    }

    private void addPrimaryKeys(Set<String> primaryKeys, AnalyzedColumnDefinition<T> column) {
        if (column.hasPrimaryKeyConstraint()) {
            String fqn = column.ident().fqn();
            AnalyzedTableElements.checkPrimaryKeyAlreadyDefined(primaryKeys, fqn);
            primaryKeys.add(fqn);
        }
        for (AnalyzedColumnDefinition<T> analyzedColumnDefinition : column.children()) {
            this.addPrimaryKeys(primaryKeys, analyzedColumnDefinition);
        }
    }

    private static void checkPrimaryKeyAlreadyDefined(Set<String> primaryKeys, String columnName) {
        if (primaryKeys.contains(columnName)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column \"%s\" appears twice in primary key constraint", columnName));
        }
    }

    void addPrimaryKey(T fqColumnName) {
        this.additionalPrimaryKeys.add(fqColumnName);
    }

    public void add(AnalyzedColumnDefinition<T> analyzedColumnDefinition) {
        if (this.columnIdents.contains(analyzedColumnDefinition.ident())) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "column \"%s\" specified more than once", analyzedColumnDefinition.ident().sqlFqn()));
        }
        this.columnIdents.add(analyzedColumnDefinition.ident());
        this.columns.add(analyzedColumnDefinition);
        this.columnTypes.put(analyzedColumnDefinition.ident(), analyzedColumnDefinition.dataType());
        if (analyzedColumnDefinition.isGenerated()) {
            ++this.numGeneratedColumns;
        }
    }

    public static Settings validateAndBuildSettings(AnalyzedTableElements<Object> tableElementsEvaluated, FulltextAnalyzerResolver fulltextAnalyzerResolver) {
        Settings.Builder builder = Settings.builder();
        for (AnalyzedColumnDefinition<Object> analyzedColumnDefinition : tableElementsEvaluated.columns) {
            AnalyzedColumnDefinition.applyAndValidateAnalyzerSettings(analyzedColumnDefinition, fulltextAnalyzerResolver);
            builder.put(analyzedColumnDefinition.builtAnalyzerSettings());
        }
        return builder.build();
    }

    public static Map<String, Object> finalizeAndValidate(RelationName relationName, AnalyzedTableElements<Symbol> tableElementsWithExpressionSymbols, AnalyzedTableElements<Object> tableElementsEvaluated) {
        tableElementsEvaluated.expandColumnIdents();
        AnalyzedTableElements.validateExpressions(tableElementsWithExpressionSymbols, tableElementsEvaluated);
        for (AnalyzedColumnDefinition column : tableElementsEvaluated.columns) {
            column.validate();
            tableElementsEvaluated.addCopyToInfo(column);
        }
        AnalyzedTableElements.validateIndexDefinitions(relationName, tableElementsEvaluated);
        AnalyzedTableElements.validatePrimaryKeys(relationName, tableElementsEvaluated);
        return AnalyzedTableElements.toMapping(tableElementsEvaluated);
    }

    private static void validateExpressions(AnalyzedTableElements<Symbol> tableElementsWithExpressionSymbols, AnalyzedTableElements<Object> tableElementsEvaluated) {
        for (int i = 0; i < tableElementsWithExpressionSymbols.columns.size(); ++i) {
            AnalyzedTableElements.processExpressions(tableElementsWithExpressionSymbols.columns.get(i), tableElementsEvaluated.columns.get(i));
        }
    }

    public TableReferenceResolver referenceResolver(RelationName relationName) {
        ArrayList<Reference> tableReferences = new ArrayList<Reference>();
        for (AnalyzedColumnDefinition<T> columnDefinition : this.columns) {
            AnalyzedTableElements.buildReference(relationName, columnDefinition, tableReferences);
        }
        return new TableReferenceResolver(tableReferences, relationName);
    }

    private static void processExpressions(AnalyzedColumnDefinition<Symbol> columnDefinitionWithExpressionSymbols, AnalyzedColumnDefinition<Object> columnDefinitionEvaluated) {
        Symbol defaultExpression;
        Symbol generatedExpression = columnDefinitionWithExpressionSymbols.generatedExpression();
        if (generatedExpression != null) {
            AnalyzedTableElements.validateAndFormatExpression(generatedExpression, columnDefinitionWithExpressionSymbols, columnDefinitionEvaluated, columnDefinitionEvaluated::formattedGeneratedExpression);
        }
        if ((defaultExpression = columnDefinitionWithExpressionSymbols.defaultExpression()) != null) {
            RefVisitor.visitRefs(defaultExpression, r -> {
                throw new UnsupportedOperationException("Columns cannot be used in this context. Maybe you wanted to use a string literal which requires single quotes: '" + r.column().sqlFqn() + "'");
            });
            AnalyzedTableElements.validateAndFormatExpression(defaultExpression, columnDefinitionWithExpressionSymbols, columnDefinitionEvaluated, columnDefinitionEvaluated::formattedDefaultExpression);
        }
        for (int i = 0; i < columnDefinitionWithExpressionSymbols.children().size(); ++i) {
            AnalyzedTableElements.processExpressions(columnDefinitionWithExpressionSymbols.children().get(i), columnDefinitionEvaluated.children().get(i));
        }
    }

    private static void validateAndFormatExpression(Symbol function, AnalyzedColumnDefinition<Symbol> columnDefinitionWithExpressionSymbols, AnalyzedColumnDefinition<Object> columnDefinitionEvaluated, Consumer<String> formattedExpressionConsumer) {
        String formattedExpression;
        DataType valueType = function.valueType();
        ArrayType definedType = columnDefinitionWithExpressionSymbols.dataType();
        if (SymbolVisitors.any(Symbols::isAggregate, function)) {
            throw new UnsupportedOperationException("Aggregation functions are not allowed in generated columns: " + function);
        }
        if (definedType != null && !((DataType)definedType).equals(valueType)) {
            ArrayType columnDataType = "array".equals(columnDefinitionWithExpressionSymbols.collectionType()) ? new ArrayType(definedType) : definedType;
            if (!valueType.isConvertableTo(columnDataType, false)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "expression value type '%s' not supported for conversion to '%s'", valueType, ((DataType)columnDataType).getName()));
            }
            Symbol castFunction = CastFunctionResolver.generateCastFunction(function, columnDataType, new CastMode[0]);
            formattedExpression = castFunction.toString(Style.UNQUALIFIED);
        } else {
            if (valueType instanceof ArrayType) {
                columnDefinitionEvaluated.collectionType("array");
                columnDefinitionEvaluated.dataType(ArrayType.unnest(valueType).getName());
            } else {
                columnDefinitionEvaluated.dataType(valueType.getName());
            }
            formattedExpression = function.toString(Style.UNQUALIFIED);
        }
        formattedExpressionConsumer.accept(formattedExpression);
    }

    private static <T> void buildReference(RelationName relationName, AnalyzedColumnDefinition<T> columnDefinition, List<Reference> references) {
        DataType type = columnDefinition.dataType() == null ? DataTypes.UNDEFINED : columnDefinition.dataType();
        DataType realType = "array".equals(columnDefinition.collectionType()) ? new ArrayType<Object>(type) : type;
        Reference reference = !columnDefinition.isGenerated() ? new Reference(new ReferenceIdent(relationName, columnDefinition.ident()), RowGranularity.DOC, realType, columnDefinition.position, null) : new GeneratedReference(columnDefinition.position, new ReferenceIdent(relationName, columnDefinition.ident()), RowGranularity.DOC, realType, "dummy expression, real one not needed here");
        references.add(reference);
        for (AnalyzedColumnDefinition<T> childDefinition : columnDefinition.children()) {
            AnalyzedTableElements.buildReference(relationName, childDefinition, references);
        }
    }

    private void addCopyToInfo(AnalyzedColumnDefinition<T> column) {
        Set<String> targets;
        if (!column.isIndexColumn() && (targets = this.copyToMap.get(column.ident().fqn())) != null) {
            column.addCopyTo(targets);
        }
        for (AnalyzedColumnDefinition<T> child : column.children()) {
            this.addCopyToInfo(child);
        }
    }

    private static void validatePrimaryKeys(RelationName relationName, AnalyzedTableElements<Object> elements) {
        for (Object additionalPrimaryKey : elements.additionalPrimaryKeys) {
            ColumnIdent columnIdent = ColumnIdent.fromPath(additionalPrimaryKey.toString());
            if (elements.columnIdents.contains(columnIdent)) continue;
            throw new ColumnUnknownException(columnIdent.sqlFqn(), relationName);
        }
        AnalyzedTableElements.primaryKeys(elements);
    }

    private static void validateIndexDefinitions(RelationName relationName, AnalyzedTableElements<Object> tableElements) {
        for (Map.Entry entry : tableElements.copyToMap.entrySet()) {
            ColumnIdent columnIdent = ColumnIdent.fromPath(entry.getKey().toString());
            if (!tableElements.columnIdents.contains(columnIdent)) {
                throw new ColumnUnknownException(columnIdent.sqlFqn(), relationName);
            }
            if (DataTypes.STRING.equals(tableElements.columnTypes.get(columnIdent))) continue;
            throw new IllegalArgumentException("INDEX definition only support 'string' typed source columns");
        }
    }

    void addCopyTo(T sourceColumn, String targetIndex) {
        Set<String> targetColumns = this.copyToMap.get(sourceColumn);
        if (targetColumns == null) {
            targetColumns = new HashSet<String>();
            this.copyToMap.put(sourceColumn, targetColumns);
        }
        targetColumns.add(targetIndex);
    }

    public Set<ColumnIdent> columnIdents() {
        return this.columnIdents;
    }

    @Nullable
    private static AnalyzedColumnDefinition<Object> columnDefinitionByIdent(AnalyzedTableElements<Object> elements, ColumnIdent ident) {
        AnalyzedColumnDefinition result = null;
        ColumnIdent root = ident.getRoot();
        for (AnalyzedColumnDefinition column : elements.columns) {
            if (!column.ident().equals(root)) continue;
            result = column;
            break;
        }
        if (result == null) {
            return null;
        }
        if (result.ident().equals(ident)) {
            return result;
        }
        return AnalyzedTableElements.findInChildren(result, ident);
    }

    private static AnalyzedColumnDefinition<Object> findInChildren(AnalyzedColumnDefinition<Object> column, ColumnIdent ident) {
        AnalyzedColumnDefinition<Object> result = null;
        for (AnalyzedColumnDefinition<Object> child : column.children()) {
            if (child.ident().equals(ident)) {
                result = child;
                break;
            }
            AnalyzedColumnDefinition<Object> inChildren = AnalyzedTableElements.findInChildren(child, ident);
            if (inChildren == null) continue;
            return inChildren;
        }
        return result;
    }

    public static void changeToPartitionedByColumn(AnalyzedTableElements<Object> elements, ColumnIdent partitionedByIdent, boolean skipIfNotFound, RelationName relationName) {
        if (partitionedByIdent.name().startsWith("_")) {
            throw new IllegalArgumentException("Cannot use system columns in PARTITIONED BY clause");
        }
        if (!AnalyzedTableElements.primaryKeys(elements).isEmpty() && !AnalyzedTableElements.primaryKeys(elements).contains(partitionedByIdent.fqn())) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use non primary key column '%s' in PARTITIONED BY clause if primary key is set on table", partitionedByIdent.sqlFqn()));
        }
        AnalyzedColumnDefinition<Object> columnDefinition = AnalyzedTableElements.columnDefinitionByIdent(elements, partitionedByIdent);
        if (columnDefinition == null) {
            if (skipIfNotFound) {
                return;
            }
            throw new ColumnUnknownException(partitionedByIdent.sqlFqn(), relationName);
        }
        DataType columnType = columnDefinition.dataType();
        if (!DataTypes.isPrimitive(columnType)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use column %s of type %s in PARTITIONED BY clause", columnDefinition.ident().sqlFqn(), columnDefinition.dataType()));
        }
        if (columnDefinition.isArrayOrInArray()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use array column %s in PARTITIONED BY clause", columnDefinition.ident().sqlFqn()));
        }
        if (columnDefinition.indexConstraint() == Reference.IndexType.ANALYZED) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use column %s with fulltext index in PARTITIONED BY clause", columnDefinition.ident().sqlFqn()));
        }
        elements.columnIdents.remove(columnDefinition.ident());
        columnDefinition.indexConstraint(Reference.IndexType.NO);
        elements.partitionedByColumns.add(columnDefinition);
    }

    public List<AnalyzedColumnDefinition<T>> columns() {
        return this.columns;
    }

    private void addCheckConstraint(String fqRelationName, @Nullable String columnName, @Nullable String name, String expressionStr) {
        String uniqueName = name;
        if (uniqueName == null) {
            uniqueName = AnalyzedTableElements.uniqueCheckConstraintName(fqRelationName, columnName);
        }
        if (this.checkConstraints.put(uniqueName, expressionStr) != null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "a check constraint of the same name is already declared [%s]", uniqueName));
        }
    }

    private static String uniqueCheckConstraintName(String fqTableName, @Nullable String columnName) {
        StringBuilder sb = new StringBuilder(fqTableName.replaceAll("\\.", "_"));
        if (columnName != null) {
            sb.append("_").append(columnName);
        }
        sb.append("_check_");
        String uuid = UUID.randomUUID().toString();
        int idx = uuid.lastIndexOf("-");
        sb.append(idx > 0 ? uuid.substring(idx + 1) : uuid);
        return sb.toString();
    }

    public void addCheckConstraint(RelationName relationName, CheckConstraint<?> check) {
        this.addCheckConstraint(relationName.fqn(), check.columnName(), check.name(), check.expressionStr());
    }

    public void addCheckColumnConstraint(RelationName relationName, CheckColumnConstraint<?> check) {
        this.addCheckConstraint(relationName.fqn(), check.columnName(), check.name(), check.expressionStr());
    }

    @VisibleForTesting
    Map<String, String> getCheckConstraints() {
        return Map.copyOf(this.checkConstraints);
    }

    public boolean hasGeneratedColumns() {
        return this.numGeneratedColumns > 0;
    }
}

