/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.types.DataTypes;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class AnalyzedShowCreateTable
implements AnalyzedStatement,
AnalyzedRelation {
    private final DocTableInfo tableInfo;
    private final List<ScopedSymbol> fields;
    private final RelationName relationName;

    public AnalyzedShowCreateTable(DocTableInfo tableInfo) {
        String columnName = "SHOW CREATE TABLE " + tableInfo.ident().fqn();
        this.relationName = new RelationName(null, "SHOW CREATE TABLE");
        this.fields = Collections.singletonList(new ScopedSymbol(this.relationName, new ColumnIdent(columnName), DataTypes.STRING));
        this.tableInfo = tableInfo;
    }

    public DocTableInfo tableInfo() {
        return this.tableInfo;
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitShowCreateTableAnalyzedStatement(this, context);
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitShowCreateTable(this, context);
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation) throws UnsupportedOperationException, ColumnUnknownException {
        throw new UnsupportedOperationException("Cannot use getField on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean isWriteOperation() {
        return false;
    }

    @Override
    public RelationName relationName() {
        return this.relationName;
    }

    @Override
    @Nonnull
    public List<Symbol> outputs() {
        return List.copyOf(this.fields);
    }
}

