/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.SetStatement;
import java.util.List;
import java.util.function.Consumer;

public class AnalyzedSetStatement
implements AnalyzedStatement {
    private final List<Assignment<Symbol>> settings;
    private final SetStatement.Scope scope;
    private final boolean persistent;

    AnalyzedSetStatement(SetStatement.Scope scope, List<Assignment<Symbol>> settings, boolean persistent) {
        this.scope = scope;
        this.settings = settings;
        this.persistent = persistent;
    }

    public SetStatement.Scope scope() {
        return this.scope;
    }

    public List<Assignment<Symbol>> settings() {
        return this.settings;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Assignment<Symbol> symbols : this.settings) {
            symbols.expressions().forEach(consumer);
        }
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitSetStatement(this, context);
    }

    @Override
    public boolean isWriteOperation() {
        return SetStatement.Scope.GLOBAL.equals((Object)this.scope);
    }
}

