/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.DDLStatement;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.Table;
import java.util.Map;
import java.util.function.Consumer;

public class AnalyzedRefreshTable
implements DDLStatement {
    private final Map<Table<Symbol>, DocTableInfo> tables;

    AnalyzedRefreshTable(Map<Table<Symbol>, DocTableInfo> tables) {
        this.tables = tables;
    }

    public Map<Table<Symbol>, DocTableInfo> tables() {
        return this.tables;
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitRefreshTableStatement(this, context);
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Map.Entry<Table<Symbol>, DocTableInfo> entry : this.tables.entrySet()) {
            Table<Symbol> table = entry.getKey();
            for (Assignment<Symbol> partitionProperty : table.partitionProperties()) {
                consumer.accept(partitionProperty.columnName());
                partitionProperty.expressions().forEach(consumer);
            }
        }
    }
}

