/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.AnalyzedTableElements;
import io.crate.analyze.DDLStatement;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.TableElement;
import java.util.function.Consumer;

public class AnalyzedCreateTable
implements DDLStatement {
    private final RelationName relationName;
    private final CreateTable<Symbol> createTable;
    private final AnalyzedTableElements<Symbol> analyzedTableElements;
    private final AnalyzedTableElements<Symbol> analyzedTableElementsWithExpressions;

    public AnalyzedCreateTable(RelationName relationName, CreateTable<Symbol> createTable, AnalyzedTableElements<Symbol> analyzedTableElements, AnalyzedTableElements<Symbol> analyzedTableElementsWithExpressions) {
        this.relationName = relationName;
        this.createTable = createTable;
        this.analyzedTableElements = analyzedTableElements;
        this.analyzedTableElementsWithExpressions = analyzedTableElementsWithExpressions;
    }

    public CreateTable<Symbol> createTable() {
        return this.createTable;
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public AnalyzedTableElements<Symbol> analyzedTableElements() {
        return this.analyzedTableElements;
    }

    public AnalyzedTableElements<Symbol> analyzedTableElementsWithExpressions() {
        return this.analyzedTableElementsWithExpressions;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Assignment<Symbol> assignment : this.createTable.name().partitionProperties()) {
            consumer.accept(assignment.expression());
            assignment.expressions().forEach(consumer);
        }
        for (TableElement tableElement : this.createTable.tableElements()) {
            tableElement.visit(consumer);
        }
        this.createTable.clusteredBy().ifPresent(x -> {
            x.column().ifPresent(consumer);
            x.numberOfShards().ifPresent(consumer);
        });
        this.createTable.partitionedBy().ifPresent(x -> x.columns().forEach(consumer));
        this.createTable.properties().properties().values().forEach(consumer);
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }
}

