/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.DDLStatement;
import io.crate.expression.symbol.Symbol;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.function.Consumer;
import org.elasticsearch.snapshots.Snapshot;

public class AnalyzedCreateSnapshot
implements DDLStatement {
    public static final List<String> ALL_INDICES = List.of("*", "-.blob_*");
    private final Snapshot snapshot;
    private final List<Table<Symbol>> tables;
    private final GenericProperties<Symbol> properties;

    AnalyzedCreateSnapshot(Snapshot snapshot, List<Table<Symbol>> tables, GenericProperties<Symbol> properties) {
        this.snapshot = snapshot;
        this.tables = tables;
        this.properties = properties;
    }

    public Snapshot snapshot() {
        return this.snapshot;
    }

    public GenericProperties<Symbol> properties() {
        return this.properties;
    }

    public List<Table<Symbol>> tables() {
        return this.tables;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Table<Symbol> table : this.tables) {
            for (Assignment<Symbol> partitionProperty : table.partitionProperties()) {
                partitionProperty.expressions().forEach(consumer);
            }
        }
        this.properties.properties().values().forEach(consumer);
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitCreateSnapshotAnalyzedStatement(this, context);
    }
}

