/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCopyFrom;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.util.List;
import javax.annotation.Nonnull;

public class AnalyzedCopyFromReturnSummary
extends AnalyzedCopyFrom
implements AnalyzedRelation {
    private final List<ScopedSymbol> fields;

    AnalyzedCopyFromReturnSummary(DocTableInfo tableInfo, Table<Symbol> table, GenericProperties<Symbol> properties, Symbol uri) {
        super(tableInfo, table, properties, uri);
        this.fields = List.of(new ScopedSymbol(tableInfo.ident(), new ColumnIdent("node"), ObjectType.builder().setInnerType("id", DataTypes.STRING).setInnerType("name", DataTypes.STRING).build()), new ScopedSymbol(tableInfo.ident(), new ColumnIdent("uri"), DataTypes.STRING), new ScopedSymbol(tableInfo.ident(), new ColumnIdent("success_count"), DataTypes.LONG), new ScopedSymbol(tableInfo.ident(), new ColumnIdent("error_count"), DataTypes.LONG), new ScopedSymbol(tableInfo.ident(), new ColumnIdent("errors"), DataTypes.UNTYPED_OBJECT));
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " is virtual relation, visiting it is unsupported");
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation) throws UnsupportedOperationException, ColumnUnknownException {
        throw new UnsupportedOperationException("Cannot use getField on " + this.getClass().getSimpleName());
    }

    @Override
    public RelationName relationName() {
        return this.tableInfo().ident();
    }

    @Override
    @Nonnull
    public List<Symbol> outputs() {
        return List.copyOf(this.fields);
    }
}

