/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import io.crate.types.DataType;
import java.util.function.Consumer;

public class AnalyzedCopyFrom
implements AnalyzedStatement {
    private final DocTableInfo tableInfo;
    private final Table<Symbol> table;
    private final GenericProperties<Symbol> properties;
    private final Symbol uri;

    AnalyzedCopyFrom(DocTableInfo tableInfo, Table<Symbol> table, GenericProperties<Symbol> properties, Symbol uri) {
        this.tableInfo = tableInfo;
        this.table = table;
        this.properties = properties;
        this.uri = uri;
    }

    public DocTableInfo tableInfo() {
        return this.tableInfo;
    }

    public GenericProperties<Symbol> properties() {
        return this.properties;
    }

    public Table<Symbol> table() {
        return this.table;
    }

    public Symbol uri() {
        return this.uri;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Assignment<Symbol> partitionProperty : this.table.partitionProperties()) {
            partitionProperty.expressions().forEach(consumer);
        }
        this.properties.properties().values().forEach(consumer);
        consumer.accept(this.uri);
    }

    @Override
    public boolean isWriteOperation() {
        return true;
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitCopyFromStatement(this, context);
    }

    public static IllegalArgumentException raiseInvalidType(DataType dataType) {
        throw new IllegalArgumentException("fileUri must be of type STRING or STRING ARRAY. Got " + dataType);
    }
}

