/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.GenericPropertiesConverter;
import io.crate.analyze.ddl.GeoSettingsApplier;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.Reference;
import io.crate.metadata.table.ColumnPolicies;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.GenericProperties;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.StringType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;

public class AnalyzedColumnDefinition<T> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(AnalyzedColumnDefinition.class));
    private static final Set<Integer> UNSUPPORTED_PK_TYPE_IDS = Set.of(Integer.valueOf(12), Integer.valueOf(DataTypes.GEO_POINT.id()), Integer.valueOf(DataTypes.GEO_SHAPE.id()));
    private static final Set<Integer> UNSUPPORTED_INDEX_TYPE_IDS = Set.of(Integer.valueOf(12), Integer.valueOf(DataTypes.GEO_POINT.id()), Integer.valueOf(DataTypes.GEO_SHAPE.id()));
    private static final String COLUMN_STORE_PROPERTY = "columnstore";
    private final AnalyzedColumnDefinition<T> parent;
    public Integer position;
    private ColumnIdent ident;
    private String name;
    private DataType dataType;
    private String collectionType;
    private String geoTree;
    @Nullable
    private GenericProperties<T> geoProperties;
    private Reference.IndexType indexType;
    @Nullable
    private T analyzer;
    private String indexMethod;
    private Settings analyzerSettings = Settings.EMPTY;
    @VisibleForTesting
    ColumnPolicy objectType = ColumnPolicy.DYNAMIC;
    private boolean isPrimaryKey = false;
    private boolean isNotNull = false;
    private List<AnalyzedColumnDefinition<T>> children = new ArrayList<AnalyzedColumnDefinition<T>>();
    private boolean isIndex = false;
    private ArrayList<String> copyToTargets;
    private boolean isParentColumn;
    @Nullable
    private GenericProperties<T> storageProperties;
    private boolean generated;
    @Nullable
    private String formattedGeneratedExpression;
    @Nullable
    private T generatedExpression;
    @Nullable
    private String formattedDefaultExpression;
    @Nullable
    private T defaultExpression;

    public AnalyzedColumnDefinition(Integer position, @Nullable AnalyzedColumnDefinition<T> parent) {
        this.position = position;
        this.parent = parent;
    }

    private AnalyzedColumnDefinition(AnalyzedColumnDefinition<T> parent, Integer position, ColumnIdent ident, String name, DataType dataType, String collectionType, Reference.IndexType indexType, String geoTree, T analyzer, String indexMethod, ColumnPolicy objectType, boolean isPrimaryKey, boolean isNotNull, Settings analyzerSettings, GenericProperties<T> geoProperties, List<AnalyzedColumnDefinition<T>> children, boolean isIndex, ArrayList<String> copyToTargets, boolean isParentColumn, GenericProperties<T> storageProperties, @Nullable String formattedGeneratedExpression, @Nullable T generatedExpression, @Nullable String formattedDefaultExpression, @Nullable T defaultExpression, boolean generated) {
        this.parent = parent;
        this.position = position;
        this.ident = ident;
        this.name = name;
        this.dataType = dataType;
        this.collectionType = collectionType;
        this.indexType = indexType;
        this.geoTree = geoTree;
        this.analyzer = analyzer;
        this.indexMethod = indexMethod;
        this.objectType = objectType;
        this.isPrimaryKey = isPrimaryKey;
        this.isNotNull = isNotNull;
        this.analyzerSettings = analyzerSettings;
        this.geoProperties = geoProperties;
        this.children = children;
        this.isIndex = isIndex;
        this.copyToTargets = copyToTargets;
        this.isParentColumn = isParentColumn;
        this.storageProperties = storageProperties;
        this.formattedGeneratedExpression = formattedGeneratedExpression;
        this.generatedExpression = generatedExpression;
        this.formattedDefaultExpression = formattedDefaultExpression;
        this.defaultExpression = defaultExpression;
        this.generated = generated;
    }

    public <U> AnalyzedColumnDefinition<U> map(Function<? super T, ? extends U> mapper) {
        return new AnalyzedColumnDefinition<Object>((AnalyzedColumnDefinition<Object>)(this.parent == null ? null : this.parent), this.position, this.ident, this.name, this.dataType, this.collectionType, this.indexType, this.geoTree, (this.analyzer == null ? null : (T)mapper.apply((T)this.analyzer)), this.indexMethod, this.objectType, this.isPrimaryKey, this.isNotNull, this.analyzerSettings, (GenericProperties<Object>)(this.geoProperties == null ? null : this.geoProperties.map(mapper)), (List<AnalyzedColumnDefinition<Object>>)Lists2.map(this.children, x -> x.map(mapper)), this.isIndex, this.copyToTargets, this.isParentColumn, (GenericProperties<Object>)(this.storageProperties == null ? null : this.storageProperties.map(mapper)), this.formattedDefaultExpression, (this.generatedExpression == null ? null : (T)mapper.apply((T)this.generatedExpression)), this.formattedDefaultExpression, (this.defaultExpression == null ? null : (T)mapper.apply((T)this.defaultExpression)), this.generated);
    }

    public void visitSymbols(Consumer<? super T> consumer) {
        if (this.analyzer != null) {
            consumer.accept(this.analyzer);
        }
        if (this.geoProperties != null) {
            this.geoProperties.properties().values().forEach(consumer);
        }
        for (AnalyzedColumnDefinition<T> child : this.children) {
            child.visitSymbols(consumer);
        }
        if (this.storageProperties != null) {
            this.storageProperties.properties().values().forEach(consumer);
        }
        if (this.generatedExpression != null) {
            consumer.accept(this.generatedExpression);
        }
        if (this.defaultExpression != null) {
            consumer.accept(this.defaultExpression);
        }
    }

    public void name(String name) {
        this.name = name;
        this.ident = this.parent != null ? ColumnIdent.getChildSafe(this.parent.ident, name) : ColumnIdent.fromNameSafe(name);
    }

    public void analyzer(T analyzer) {
        this.analyzer = analyzer;
    }

    void indexMethod(String indexMethod) {
        this.indexMethod = indexMethod;
    }

    public void indexConstraint(Reference.IndexType indexType) {
        this.indexType = indexType;
    }

    @Nullable
    Reference.IndexType indexConstraint() {
        return this.indexType;
    }

    private void analyzerSettings(Settings settings) {
        this.analyzerSettings = settings;
    }

    void geoTree(String geoTree) {
        this.geoTree = geoTree;
    }

    void geoProperties(GenericProperties<T> properties) {
        this.geoProperties = properties;
    }

    public void dataType(String dataType) {
        this.dataType(dataType, List.of(), true);
    }

    public void dataType(String typeName, List<Integer> parameters, boolean logWarnings) {
        if ("timestamp".equals(typeName) && logWarnings) {
            DEPRECATION_LOGGER.deprecated("Column [{}]: Usage of the `TIMESTAMP` data type as a timestamp with zone is deprecated, use the `TIMESTAMPTZ` or `TIMESTAMP WITH TIME ZONE` data type instead.", this.ident.fqn());
        }
        this.dataType = DataTypes.of(typeName, parameters);
    }

    public DataType dataType() {
        return this.dataType;
    }

    void objectType(ColumnPolicy objectType) {
        this.objectType = objectType;
    }

    void collectionType(String type) {
        this.collectionType = type;
    }

    String collectionType() {
        return this.collectionType;
    }

    public boolean isIndexColumn() {
        return this.isIndex;
    }

    void setAsIndexColumn() {
        this.isIndex = true;
    }

    public void addChild(AnalyzedColumnDefinition<T> analyzedColumnDefinition) {
        this.children.add(analyzedColumnDefinition);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    Settings builtAnalyzerSettings() {
        if (!this.children().isEmpty()) {
            Settings.Builder builder = Settings.builder();
            builder.put(this.analyzerSettings);
            for (AnalyzedColumnDefinition<T> child : this.children()) {
                builder.put(child.builtAnalyzerSettings());
            }
            return builder.build();
        }
        return this.analyzerSettings;
    }

    private static void applyAndValidateStorageSettings(Map<String, Object> mapping, AnalyzedColumnDefinition<Object> definition) {
        if (definition.storageProperties == null) {
            return;
        }
        Settings storageSettings = GenericPropertiesConverter.genericPropertiesToSettings(definition.storageProperties);
        for (String property : storageSettings.names()) {
            if (property.equals(COLUMN_STORE_PROPERTY)) {
                DataType dataType = definition.dataType();
                boolean val = storageSettings.getAsBoolean(property, true);
                if (val) continue;
                if (!DataTypes.isSameType(dataType, DataTypes.STRING)) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid storage option \"columnstore\" for data type \"%s\"", dataType.getName()));
                }
                mapping.put("doc_values", "false");
                continue;
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid storage option \"%s\"", storageSettings.get(property)));
        }
    }

    static void applyAndValidateAnalyzerSettings(AnalyzedColumnDefinition<Object> definition, FulltextAnalyzerResolver fulltextAnalyzerResolver) {
        if (definition.analyzer == null) {
            if (definition.indexMethod != null) {
                if (definition.indexMethod.equals("plain")) {
                    definition.analyzer("keyword");
                } else {
                    definition.analyzer("standard");
                }
            }
        } else {
            if (definition.analyzer instanceof Object[]) {
                throw new IllegalArgumentException("array literal not allowed for the analyzer property");
            }
            String analyzerName = DataTypes.STRING.sanitizeValue(definition.analyzer);
            if (fulltextAnalyzerResolver.hasCustomAnalyzer(analyzerName)) {
                Settings settings = fulltextAnalyzerResolver.resolveFullCustomAnalyzerSettings(analyzerName);
                definition.analyzerSettings(settings);
            }
        }
        for (AnalyzedColumnDefinition<Object> child : definition.children()) {
            AnalyzedColumnDefinition.applyAndValidateAnalyzerSettings(child, fulltextAnalyzerResolver);
        }
    }

    public void validate() {
        if (this.indexType == Reference.IndexType.ANALYZED && !DataTypes.STRING.equals(this.dataType)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Can't use an Analyzer on column %s because analyzers are only allowed on columns of type \"" + DataTypes.STRING.getName() + "\" of the unbound length limit.", this.ident.sqlFqn()));
        }
        if (this.indexType != null && UNSUPPORTED_INDEX_TYPE_IDS.contains(this.dataType.id())) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "INDEX constraint cannot be used on columns of type \"%s\"", this.dataType));
        }
        if (DataTypes.STORAGE_UNSUPPORTED.contains(this.dataType)) {
            throw new IllegalArgumentException("Cannot use the type `" + this.dataType.getName() + "` for column: " + this.name);
        }
        if (this.hasPrimaryKeyConstraint()) {
            this.ensureTypeCanBeUsedAsKey();
        }
        for (AnalyzedColumnDefinition<T> child : this.children) {
            child.validate();
        }
    }

    private void ensureTypeCanBeUsedAsKey() {
        if (this.collectionType != null) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use columns of type \"%s\" as primary key", this.collectionType));
        }
        if (UNSUPPORTED_PK_TYPE_IDS.contains(this.dataType.id())) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use columns of type \"%s\" as primary key", this.dataType));
        }
        if (this.isArrayOrInArray()) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use column \"%s\" as primary key within an array object", this.name));
        }
    }

    public String name() {
        return this.name;
    }

    static Map<String, Object> toMapping(AnalyzedColumnDefinition<Object> definition) {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        AnalyzedColumnDefinition.addTypeOptions(mapping, definition);
        mapping.put("type", definition.typeNameForESMapping());
        if (definition.position != null) {
            mapping.put("position", definition.position);
        }
        if (definition.indexType == Reference.IndexType.NO) {
            mapping.put("index", false);
        }
        if (definition.copyToTargets != null) {
            mapping.put("copy_to", definition.copyToTargets);
        }
        if ("array".equals(definition.collectionType)) {
            HashMap<String, Object> outerMapping = new HashMap<String, Object>();
            outerMapping.put("type", "array");
            if (definition.dataType().id() == 12) {
                AnalyzedColumnDefinition.objectMapping(mapping, definition);
            }
            outerMapping.put("inner", mapping);
            return outerMapping;
        }
        if (definition.dataType().id() == 12) {
            AnalyzedColumnDefinition.objectMapping(mapping, definition);
        }
        AnalyzedColumnDefinition.applyAndValidateStorageSettings(mapping, definition);
        if (definition.formattedDefaultExpression != null) {
            mapping.put("default_expr", definition.formattedDefaultExpression);
        }
        return mapping;
    }

    String typeNameForESMapping() {
        if (4 == this.dataType.id()) {
            return this.analyzer == null && !this.isIndex ? "keyword" : "text";
        }
        return DataTypes.esMappingNameFrom(this.dataType.id());
    }

    private static void addTypeOptions(Map<String, Object> mapping, AnalyzedColumnDefinition<Object> definition) {
        switch (definition.dataType.id()) {
            case 11: {
                mapping.put("format", "epoch_millis||strict_date_optional_time");
                break;
            }
            case 15: {
                mapping.put("format", "epoch_millis||strict_date_optional_time");
                mapping.put("ignore_timezone", true);
                break;
            }
            case 14: {
                if (definition.geoProperties == null) break;
                GeoSettingsApplier.applySettings(mapping, definition.geoProperties, definition.geoTree);
                break;
            }
            case 4: {
                StringType stringType;
                if (definition.analyzer != null) {
                    mapping.put("analyzer", DataTypes.STRING.sanitizeValue(definition.analyzer));
                }
                if ((stringType = (StringType)definition.dataType).unbound()) break;
                mapping.put("length_limit", stringType.lengthLimit());
                break;
            }
        }
    }

    private static void objectMapping(Map<String, Object> mapping, AnalyzedColumnDefinition<Object> definition) {
        mapping.put("dynamic", ColumnPolicies.encodeMappingValue(definition.objectType));
        HashMap<String, Map<String, Object>> childProperties = new HashMap<String, Map<String, Object>>();
        for (AnalyzedColumnDefinition<Object> analyzedColumnDefinition : definition.children) {
            childProperties.put(analyzedColumnDefinition.name(), AnalyzedColumnDefinition.toMapping(analyzedColumnDefinition));
        }
        mapping.put("properties", childProperties);
    }

    public ColumnIdent ident() {
        return this.ident;
    }

    public void setPrimaryKeyConstraint() {
        this.isPrimaryKey = true;
    }

    boolean hasPrimaryKeyConstraint() {
        return this.isPrimaryKey;
    }

    void setNotNullConstraint() {
        this.isNotNull = true;
    }

    boolean hasNotNullConstraint() {
        return this.isNotNull;
    }

    Map<String, Object> toMetaIndicesMapping() {
        return Map.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyzedColumnDefinition)) {
            return false;
        }
        AnalyzedColumnDefinition that = (AnalyzedColumnDefinition)o;
        return this.ident != null ? this.ident.equals(that.ident) : that.ident == null;
    }

    public int hashCode() {
        return this.ident != null ? this.ident.hashCode() : 0;
    }

    public String toString() {
        return "AnalyzedColumnDefinition{ident=" + this.ident + "}";
    }

    public List<AnalyzedColumnDefinition<T>> children() {
        return this.children;
    }

    void addCopyTo(Set<String> targets) {
        this.copyToTargets = new ArrayList<String>(targets);
    }

    public void ident(ColumnIdent ident) {
        assert (this.ident == null) : "ident must be null";
        this.ident = ident;
        this.name = ident.leafName();
    }

    boolean isArrayOrInArray() {
        return this.collectionType != null || this.parent != null && this.parent.isArrayOrInArray();
    }

    void markAsParentColumn() {
        this.isParentColumn = true;
    }

    public boolean isParentColumn() {
        return this.isParentColumn;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void formattedGeneratedExpression(String formattedGeneratedExpression) {
        this.formattedGeneratedExpression = formattedGeneratedExpression;
    }

    @Nullable
    public String formattedGeneratedExpression() {
        return this.formattedGeneratedExpression;
    }

    public void generatedExpression(T generatedExpression) {
        this.generatedExpression = generatedExpression;
    }

    @Nullable
    public T generatedExpression() {
        return this.generatedExpression;
    }

    void formattedDefaultExpression(String formattedDefaultExpression) {
        this.formattedDefaultExpression = formattedDefaultExpression;
    }

    @Nullable
    public T defaultExpression() {
        return this.defaultExpression;
    }

    public void defaultExpression(T defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    void setStorageProperties(GenericProperties<T> storageProperties) {
        this.storageProperties = storageProperties;
    }
}

