/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedPromoteReplica;
import io.crate.analyze.AnalyzedRerouteAllocateReplicaShard;
import io.crate.analyze.AnalyzedRerouteCancelShard;
import io.crate.analyze.AnalyzedRerouteMoveShard;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.RerouteAnalyzedStatement;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.common.collections.Lists2;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.ShardedTable;
import io.crate.sql.tree.AlterTableReroute;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.PromoteReplica;
import io.crate.sql.tree.RerouteAllocateReplicaShard;
import io.crate.sql.tree.RerouteCancelShard;
import io.crate.sql.tree.RerouteMoveShard;
import java.util.HashMap;
import java.util.List;

public class AlterTableRerouteAnalyzer {
    private final NodeContext nodeCtx;
    private final Schemas schemas;
    private final RerouteOptionVisitor rerouteOptionVisitor;

    AlterTableRerouteAnalyzer(NodeContext nodeCtx, Schemas schemas) {
        this.nodeCtx = nodeCtx;
        this.schemas = schemas;
        this.rerouteOptionVisitor = new RerouteOptionVisitor();
    }

    public AnalyzedStatement analyze(AlterTableReroute<Expression> alterTableReroute, ParamTypeHints paramTypeHints, CoordinatorTxnCtx transactionContext) {
        RelationName relationName = alterTableReroute.blob() ? RelationName.fromBlobTable(alterTableReroute.table()) : this.schemas.resolveRelation(alterTableReroute.table().getName(), transactionContext.sessionContext().searchPath());
        ShardedTable tableInfo = (ShardedTable)this.schemas.getTableInfo(relationName, Operation.ALTER_REROUTE);
        return alterTableReroute.rerouteOption().accept(this.rerouteOptionVisitor, new Context(tableInfo, alterTableReroute.table().partitionProperties(), transactionContext, this.nodeCtx, paramTypeHints));
    }

    private static class RerouteOptionVisitor
    extends AstVisitor<RerouteAnalyzedStatement, Context> {
        private RerouteOptionVisitor() {
        }

        @Override
        public RerouteAnalyzedStatement visitRerouteMoveShard(RerouteMoveShard<?> node, Context context) {
            return new AnalyzedRerouteMoveShard(context.tableInfo, Lists2.map(context.partitionProperties, p -> p.map(a -> context.exprAnalyzerWithFields.convert((Expression)a, context.exprCtx))), node.map(x -> context.exprAnalyzer.convert((Expression)x, context.exprCtx)));
        }

        @Override
        public RerouteAnalyzedStatement visitRerouteAllocateReplicaShard(RerouteAllocateReplicaShard<?> node, Context context) {
            return new AnalyzedRerouteAllocateReplicaShard(context.tableInfo, Lists2.map(context.partitionProperties, p -> p.map(a -> context.exprAnalyzerWithFields.convert((Expression)a, context.exprCtx))), node.map(x -> context.exprAnalyzer.convert((Expression)x, context.exprCtx)));
        }

        @Override
        public RerouteAnalyzedStatement visitRerouteCancelShard(RerouteCancelShard<?> node, Context context) {
            return new AnalyzedRerouteCancelShard(context.tableInfo, Lists2.map(context.partitionProperties, p -> p.map(a -> context.exprAnalyzerWithFields.convert((Expression)a, context.exprCtx))), node.map(x -> context.exprAnalyzer.convert((Expression)x, context.exprCtx)));
        }

        @Override
        public RerouteAnalyzedStatement visitReroutePromoteReplica(PromoteReplica<?> node, Context context) {
            PromoteReplica<Symbol> promoteReplica = node.map(x -> context.exprAnalyzer.convert((Expression)x, context.exprCtx));
            HashMap<String, Symbol> properties = new HashMap<String, Symbol>(promoteReplica.properties().properties());
            Symbol acceptDataLoss = properties.remove("accept_data_loss");
            if (!properties.isEmpty()) {
                throw new IllegalArgumentException("Unsupported options provided to REROUTE PROMOTE REPLICA: " + properties.keySet());
            }
            return new AnalyzedPromoteReplica(context.tableInfo, Lists2.map(context.partitionProperties, p -> p.map(a -> context.exprAnalyzerWithFields.convert((Expression)a, context.exprCtx))), node.map(x -> context.exprAnalyzer.convert((Expression)x, context.exprCtx)), acceptDataLoss == null ? Literal.BOOLEAN_FALSE : acceptDataLoss);
        }
    }

    private static class Context {
        private final ShardedTable tableInfo;
        private final List<Assignment<Expression>> partitionProperties;
        private final ExpressionAnalyzer exprAnalyzer;
        private final ExpressionAnalysisContext exprCtx;
        private final ExpressionAnalyzer exprAnalyzerWithFields;

        private Context(ShardedTable tableInfo, List<Assignment<Expression>> partitionProperties, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints) {
            this.tableInfo = tableInfo;
            this.partitionProperties = partitionProperties;
            this.exprCtx = new ExpressionAnalysisContext();
            this.exprAnalyzer = new ExpressionAnalyzer(txnCtx, nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
            this.exprAnalyzerWithFields = new ExpressionAnalyzer(txnCtx, nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        }
    }
}

