/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.AnalyzedAlterBlobTable;
import io.crate.analyze.AnalyzedAlterTable;
import io.crate.analyze.AnalyzedAlterTableOpenClose;
import io.crate.analyze.AnalyzedAlterTableRename;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.blob.BlobTableInfo;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.AlterBlobTable;
import io.crate.sql.tree.AlterTable;
import io.crate.sql.tree.AlterTableOpenClose;
import io.crate.sql.tree.AlterTableRename;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Table;
import java.util.List;

class AlterTableAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    AlterTableAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    AnalyzedAlterTable analyze(AlterTable<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        AlterTable<Symbol> alterTable = node.map(x -> exprAnalyzerWithFieldsAsString.convert((Expression)x, exprCtx));
        DocTableInfo docTableInfo = (DocTableInfo)this.schemas.resolveTableInfo(alterTable.table().getName(), Operation.ALTER_BLOCKS, txnCtx.sessionContext().sessionUser(), txnCtx.sessionContext().searchPath());
        return new AnalyzedAlterTable(docTableInfo, alterTable);
    }

    AnalyzedAlterBlobTable analyze(AlterBlobTable<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        RelationName relationName = RelationName.fromBlobTable(node.table());
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        AlterTable<Symbol> alterTable = node.map(x -> exprAnalyzerWithFieldsAsString.convert((Expression)x, exprCtx));
        assert ("blob".equals(relationName.schema())) : "schema name must be 'blob'";
        BlobTableInfo tableInfo = (BlobTableInfo)this.schemas.getTableInfo(relationName);
        return new AnalyzedAlterBlobTable(tableInfo, alterTable);
    }

    AnalyzedAlterTableRename analyze(AlterTableRename<Expression> node, SessionContext sessionContext) {
        if (!node.table().partitionProperties().isEmpty()) {
            throw new UnsupportedOperationException("Renaming a single partition is not supported");
        }
        List<String> newIdentParts = node.newName().getParts();
        if (newIdentParts.size() > 1) {
            throw new IllegalArgumentException("Target table name must not include a schema");
        }
        RelationName relationName = node.blob() ? RelationName.fromBlobTable(node.table()) : this.schemas.resolveRelation(node.table().getName(), sessionContext.searchPath());
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.getTableInfo(relationName, Operation.ALTER_TABLE_RENAME);
        RelationName newRelationName = new RelationName(relationName.schema(), newIdentParts.get(0));
        newRelationName.ensureValidForRelationCreation();
        return new AnalyzedAlterTableRename(tableInfo, newRelationName);
    }

    public AnalyzedAlterTableOpenClose analyze(AlterTableOpenClose<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        ExpressionAnalyzer exprAnalyzerWithFieldsAsStrings = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        Table<Symbol> table = node.table().map(x -> exprAnalyzerWithFieldsAsStrings.convert((Expression)x, exprCtx));
        RelationName relationName = node.blob() ? RelationName.fromBlobTable(table) : this.schemas.resolveRelation(table.getName(), txnCtx.sessionContext().searchPath());
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.getTableInfo(relationName, Operation.ALTER_OPEN_CLOSE);
        return new AnalyzedAlterTableOpenClose(tableInfo, table, node.openTable());
    }
}

