/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedAlterTableAddColumn;
import io.crate.analyze.AnalyzedColumnDefinition;
import io.crate.analyze.AnalyzedTableElements;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.TableElementsAnalyzer;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.ExpressionToColumnIdentVisitor;
import io.crate.analyze.expressions.TableReferenceResolver;
import io.crate.analyze.relations.FieldProvider;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.AddColumnDefinition;
import io.crate.sql.tree.AlterTableAddColumn;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QualifiedName;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class AlterTableAddColumnAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    AlterTableAddColumnAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedAlterTableAddColumn analyze(AlterTableAddColumn<Expression> alterTable, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        if (!alterTable.table().partitionProperties().isEmpty()) {
            throw new UnsupportedOperationException("Adding a column to a single partition is not supported");
        }
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.resolveTableInfo(alterTable.table().getName(), Operation.ALTER, txnCtx.sessionContext().sessionUser(), txnCtx.sessionContext().searchPath());
        TableReferenceResolver referenceResolver = new TableReferenceResolver(tableInfo.columns(), tableInfo.ident());
        ExpressionAnalyzer exprAnalyzerWithReferenceResolver = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, referenceResolver, null);
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        AddColumnDefinition<Expression> tableElement = alterTable.tableElement();
        ExpressionToColumnIdentVisitor.convert(tableElement.name());
        AddColumnDefinition<Symbol> addColumnDefinition = new AddColumnDefinition<Symbol>(exprAnalyzerWithFieldsAsString.convert(tableElement.name(), exprCtx), null, tableElement.type() == null ? null : tableElement.type().map(y -> exprAnalyzerWithFieldsAsString.convert((Expression)y, exprCtx)), tableElement.constraints().stream().filter(c -> false == c instanceof CheckColumnConstraint).map(x -> x.map(y -> exprAnalyzerWithFieldsAsString.convert((Expression)y, exprCtx))).collect(Collectors.toList()), false, tableElement.generatedExpression() != null);
        AnalyzedTableElements<Symbol> analyzedTableElements = TableElementsAnalyzer.analyze(Collections.singletonList(addColumnDefinition), tableInfo.ident(), tableInfo);
        AddColumnDefinition addColumnDefinitionWithExpression = (AddColumnDefinition)tableElement.mapExpressions(addColumnDefinition, x -> exprAnalyzerWithReferenceResolver.convert((Expression)x, exprCtx));
        AnalyzedTableElements<Symbol> analyzedTableElementsWithExpressions = TableElementsAnalyzer.analyze(Collections.singletonList(addColumnDefinitionWithExpression), tableInfo.ident(), tableInfo);
        ExpressionAnalyzer checkColumnConstraintsAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, new SelfReferenceFieldProvider(tableInfo.ident(), referenceResolver, analyzedTableElements.columns()), null);
        tableElement.constraints().stream().filter(CheckColumnConstraint.class::isInstance).map(x -> x.map(y -> checkColumnConstraintsAnalyzer.convert((Expression)y, exprCtx))).forEach(c -> {
            CheckColumnConstraint check = (CheckColumnConstraint)c;
            analyzedTableElements.addCheckColumnConstraint(tableInfo.ident(), check);
            analyzedTableElementsWithExpressions.addCheckColumnConstraint(tableInfo.ident(), check);
        });
        return new AnalyzedAlterTableAddColumn(tableInfo, analyzedTableElements, analyzedTableElementsWithExpressions);
    }

    private static class SelfReferenceFieldProvider
    implements FieldProvider<Reference> {
        private final RelationName relationName;
        private final TableReferenceResolver referenceResolver;
        private final List<AnalyzedColumnDefinition<Symbol>> columnDefinitions;

        SelfReferenceFieldProvider(RelationName relationName, TableReferenceResolver referenceResolver, List<AnalyzedColumnDefinition<Symbol>> columnDefinitions) {
            this.relationName = relationName;
            this.referenceResolver = referenceResolver;
            this.columnDefinitions = columnDefinitions;
        }

        @Override
        public Reference resolveField(QualifiedName qualifiedName, @Nullable List<String> path, Operation operation) {
            try {
                Symbol ref = this.referenceResolver.resolveField(qualifiedName, (List)path, operation);
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "CHECK expressions defined in this context cannot refer to other columns: %s", ref));
            }
            catch (ColumnUnknownException cue) {
                ColumnIdent colIdent = TableReferenceResolver.columnIdent(qualifiedName, path);
                for (int i = 0; i < this.columnDefinitions.size(); ++i) {
                    AnalyzedColumnDefinition<Symbol> def = this.columnDefinitions.get(i);
                    if (!def.ident().equals(colIdent)) continue;
                    return new Reference(new ReferenceIdent(this.relationName, colIdent), RowGranularity.DOC, def.dataType(), def.position, def.defaultExpression());
                }
                throw new ColumnUnknownException(colIdent.sqlFqn(), this.relationName);
            }
        }
    }
}

