/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action.sql.parser;

import io.crate.action.sql.parser.SQLArgsParseElement;
import io.crate.action.sql.parser.SQLBulkArgsParseElement;
import io.crate.action.sql.parser.SQLParseElement;
import io.crate.action.sql.parser.SQLParseSourceException;
import io.crate.action.sql.parser.SQLRequestParseContext;
import io.crate.action.sql.parser.SQLStmtParseElement;
import io.crate.exceptions.SQLParseException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class SQLRequestParser {
    private static final Map<String, SQLParseElement> ELEMENT_PARSERS = Map.of("stmt", new SQLStmtParseElement(), "args", new SQLArgsParseElement(), "bulk_args", new SQLBulkArgsParseElement());

    private SQLRequestParser() {
    }

    private static void validate(SQLRequestParseContext parseContext) throws SQLParseSourceException {
        if (parseContext.stmt() == null) {
            throw new SQLParseSourceException("Field [stmt] was not defined");
        }
    }

    public static SQLRequestParseContext parseSource(BytesReference source) throws IOException {
        if (source.length() == 0) {
            throw new SQLParseException("Missing request body");
        }
        try (Closeable parser = null;){
            SQLRequestParseContext parseContext = new SQLRequestParseContext();
            parser = XContentFactory.xContent(XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, source.streamInput());
            SQLRequestParser.parse(parseContext, (XContentParser)parser);
            SQLRequestParser.validate(parseContext);
            SQLRequestParseContext sQLRequestParseContext = parseContext;
            return sQLRequestParseContext;
        }
    }

    public static void parse(SQLRequestParseContext parseContext, XContentParser parser) throws Exception {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String fieldName = parser.currentName();
                parser.nextToken();
                SQLParseElement element = ELEMENT_PARSERS.get(fieldName);
                if (element == null) {
                    throw new SQLParseException("No parser for element [" + fieldName + "]");
                }
                element.parse(parser, parseContext);
                continue;
            }
            if (token != null) continue;
            break;
        }
    }

    static final class Fields {
        static final String STMT = "stmt";
        static final String ARGS = "args";
        static final String BULK_ARGS = "bulk_args";

        Fields() {
        }
    }
}

