/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action.sql;

import io.crate.auth.user.User;
import io.crate.metadata.SearchPath;
import io.crate.planner.optimizer.Rule;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SessionContext {
    private final User authenticatedUser;
    private User sessionUser;
    private SearchPath searchPath;
    private boolean hashJoinEnabled = true;
    private Set<Class<? extends Rule<?>>> excludedOptimizerRules;

    public static SessionContext systemSessionContext() {
        return new SessionContext(User.CRATE_USER, User.CRATE_USER, new String[0]);
    }

    public SessionContext(User authenticatedUser, String ... searchPath) {
        this(authenticatedUser, authenticatedUser, searchPath);
    }

    public SessionContext(User authenticatedUser, User sessionUser, String ... searchPath) {
        this.authenticatedUser = Objects.requireNonNull(authenticatedUser, "Authenticated user is required");
        this.sessionUser = Objects.requireNonNull(sessionUser, "Session user is required");
        this.searchPath = SearchPath.createSearchPathFrom(searchPath);
        this.excludedOptimizerRules = new HashSet();
    }

    public void resetSchema() {
        this.searchPath = SearchPath.pathWithPGCatalogAndDoc();
    }

    public SearchPath searchPath() {
        return this.searchPath;
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public void setSearchPath(String ... schemas) {
        this.searchPath = SearchPath.createSearchPathFrom(schemas);
    }

    public boolean isHashJoinEnabled() {
        return this.hashJoinEnabled;
    }

    public void setHashJoinEnabled(boolean hashJoinEnabled) {
        this.hashJoinEnabled = hashJoinEnabled;
    }

    public User authenticatedUser() {
        return this.authenticatedUser;
    }

    public User sessionUser() {
        return this.sessionUser;
    }

    public void setSessionUser(User user) {
        this.sessionUser = user;
    }

    public Set<Class<? extends Rule<?>>> excludedOptimizerRules() {
        return this.excludedOptimizerRules;
    }

    public void resetToDefaults() {
        this.resetSchema();
        this.hashJoinEnabled = true;
    }
}

