/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action.sql;

import io.crate.action.sql.DeferredExecution;
import io.crate.action.sql.DescribeResult;
import io.crate.action.sql.ParameterTypeExtractor;
import io.crate.action.sql.PreparedStmt;
import io.crate.action.sql.ResultReceiver;
import io.crate.action.sql.RowConsumerToResultReceiver;
import io.crate.action.sql.SQLOperations;
import io.crate.action.sql.SessionContext;
import io.crate.analyze.AnalyzedBegin;
import io.crate.analyze.AnalyzedCommit;
import io.crate.analyze.AnalyzedDeallocate;
import io.crate.analyze.AnalyzedDiscard;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.Analyzer;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.Relations;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.auth.user.AccessControl;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.RowN;
import io.crate.exceptions.ReadOnlyException;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RoutingProvider;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.Planner;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.StatementClassifier;
import io.crate.planner.operators.SubQueryResults;
import io.crate.protocols.postgres.FormatCodes;
import io.crate.protocols.postgres.JobsLogsUpdateListener;
import io.crate.protocols.postgres.Portal;
import io.crate.protocols.postgres.RetryOnFailureResultReceiver;
import io.crate.protocols.postgres.TransactionState;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.DiscardStatement;
import io.crate.sql.tree.Statement;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.Randomness;

public class Session
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(SQLOperations.class);
    private static final Statement EMPTY_STMT = SqlParser.createStatement("select '' from sys.cluster limit 0");
    public static final String UNNAMED = "";
    private final DependencyCarrier executor;
    private final AccessControl accessControl;
    private final SessionContext sessionContext;
    @VisibleForTesting
    final Map<String, PreparedStmt> preparedStatements = new HashMap<String, PreparedStmt>();
    @VisibleForTesting
    final Map<String, Portal> portals = new HashMap<String, Portal>();
    @VisibleForTesting
    final Map<Statement, List<DeferredExecution>> deferredExecutionsByStmt = new HashMap<Statement, List<DeferredExecution>>();
    @Nullable
    @VisibleForTesting
    CompletableFuture<?> activeExecution;
    private final NodeContext nodeCtx;
    private final Analyzer analyzer;
    private final Planner planner;
    private final JobsLogs jobsLogs;
    private final boolean isReadOnly;
    private final ParameterTypeExtractor parameterTypeExtractor;
    private TransactionState currentTransactionState = TransactionState.IDLE;

    public Session(NodeContext nodeCtx, Analyzer analyzer, Planner planner, JobsLogs jobsLogs, boolean isReadOnly, DependencyCarrier executor, AccessControl accessControl, SessionContext sessionContext) {
        this.nodeCtx = nodeCtx;
        this.analyzer = analyzer;
        this.planner = planner;
        this.jobsLogs = jobsLogs;
        this.isReadOnly = isReadOnly;
        this.executor = executor;
        this.accessControl = accessControl;
        this.sessionContext = sessionContext;
        this.parameterTypeExtractor = new ParameterTypeExtractor();
    }

    public void quickExec(String statement, ResultReceiver<?> resultReceiver, Row params) {
        this.quickExec(statement, SqlParser::createStatement, resultReceiver, params);
    }

    public void quickExec(String statement, Function<String, Statement> parse, ResultReceiver<?> resultReceiver, Row params) {
        Plan plan;
        CoordinatorTxnCtx txnCtx = new CoordinatorTxnCtx(this.sessionContext);
        Statement parsedStmt = parse.apply(statement);
        AnalyzedStatement analyzedStatement = this.analyzer.analyze(parsedStmt, this.sessionContext, ParamTypeHints.EMPTY);
        RoutingProvider routingProvider = new RoutingProvider(Randomness.get().nextInt(), this.planner.getAwarenessAttributes());
        UUID jobId = UUID.randomUUID();
        ClusterState clusterState = this.planner.currentClusterState();
        PlannerContext plannerContext = new PlannerContext(clusterState, routingProvider, jobId, txnCtx, this.nodeCtx, 0, params);
        try {
            plan = this.planner.plan(analyzedStatement, plannerContext);
        }
        catch (Throwable t) {
            this.jobsLogs.logPreExecutionFailure(jobId, statement, SQLExceptions.messageOf(t), this.sessionContext.sessionUser());
            throw t;
        }
        StatementClassifier.Classification classification = StatementClassifier.classify(plan);
        this.jobsLogs.logExecutionStart(jobId, statement, this.sessionContext.sessionUser(), classification);
        JobsLogsUpdateListener jobsLogsUpdateListener = new JobsLogsUpdateListener(jobId, this.jobsLogs);
        if (!analyzedStatement.isWriteOperation()) {
            resultReceiver = new RetryOnFailureResultReceiver(this.executor.clusterService(), clusterState, indexName -> clusterState.metadata().hasIndex((String)indexName), resultReceiver, jobId, (newJobId, retryResultReceiver) -> this.retryQuery((UUID)newJobId, analyzedStatement, routingProvider, new RowConsumerToResultReceiver((ResultReceiver)retryResultReceiver, 0, jobsLogsUpdateListener), params, txnCtx, this.nodeCtx));
        }
        RowConsumerToResultReceiver consumer = new RowConsumerToResultReceiver(resultReceiver, 0, jobsLogsUpdateListener);
        plan.execute(this.executor, plannerContext, consumer, params, SubQueryResults.EMPTY);
    }

    private void retryQuery(UUID jobId, AnalyzedStatement stmt, RoutingProvider routingProvider, RowConsumer consumer, Row params, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx) {
        PlannerContext plannerContext = new PlannerContext(this.planner.currentClusterState(), routingProvider, jobId, txnCtx, nodeCtx, 0, params);
        Plan plan = this.planner.plan(stmt, plannerContext);
        plan.execute(this.executor, plannerContext, consumer, params, SubQueryResults.EMPTY);
    }

    private Portal getSafePortal(String portalName) {
        Portal portal = this.portals.get(portalName);
        if (portal == null) {
            throw new IllegalArgumentException("Cannot find portal: " + portalName);
        }
        return portal;
    }

    public SessionContext sessionContext() {
        return this.sessionContext;
    }

    public void parse(String statementName, String query, List<DataType> paramTypes) {
        DataType[] parameterTypes;
        AnalyzedStatement analyzedStatement;
        Statement statement;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=parse stmtName={} query={} paramTypes={}", (Object)statementName, (Object)query, paramTypes);
        }
        try {
            statement = SqlParser.createStatement(query);
        }
        catch (Throwable t) {
            if (UNNAMED.equals(query)) {
                statement = EMPTY_STMT;
            }
            this.jobsLogs.logPreExecutionFailure(UUID.randomUUID(), query, SQLExceptions.messageOf(t), this.sessionContext.sessionUser());
            throw t;
        }
        try {
            analyzedStatement = this.analyzer.analyze(statement, this.sessionContext, new ParamTypeHints(paramTypes));
            parameterTypes = this.parameterTypeExtractor.getParameterTypes(x -> Relations.traverseDeepSymbols(analyzedStatement, x));
        }
        catch (Throwable t) {
            this.jobsLogs.logPreExecutionFailure(UUID.randomUUID(), query, SQLExceptions.messageOf(t), this.sessionContext.sessionUser());
            throw t;
        }
        this.preparedStatements.put(statementName, new PreparedStmt(statement, analyzedStatement, query, parameterTypes));
    }

    public void bind(String portalName, String statementName, List<Object> params, @Nullable FormatCodes.FormatCode[] resultFormatCodes) {
        PreparedStmt preparedStmt;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=bind portalName={} statementName={} params={}", (Object)portalName, (Object)statementName, params);
        }
        try {
            preparedStmt = this.getSafeStmt(statementName);
        }
        catch (Throwable t) {
            this.jobsLogs.logPreExecutionFailure(UUID.randomUUID(), null, SQLExceptions.messageOf(t), this.sessionContext.sessionUser());
            throw t;
        }
        Portal portal = new Portal(portalName, preparedStmt, params, preparedStmt.analyzedStatement(), resultFormatCodes);
        Portal oldPortal = this.portals.put(portalName, portal);
        if (oldPortal != null) {
            oldPortal.closeActiveConsumer();
        }
    }

    public DescribeResult describe(char type, String portalOrStatement) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=describe type={} portalOrStatement={}", (Object)Character.valueOf(type), (Object)portalOrStatement);
        }
        switch (type) {
            case 'P': {
                Portal portal = this.getSafePortal(portalOrStatement);
                AnalyzedStatement analyzedStmt = portal.analyzedStatement();
                return new DescribeResult(portal.preparedStmt().parameterTypes(), analyzedStmt.outputs(), this.resolveTableFromSelect(analyzedStmt));
            }
            case 'S': {
                PreparedStmt preparedStmt = this.preparedStatements.get(portalOrStatement);
                AnalyzedStatement analyzedStatement = preparedStmt.analyzedStatement();
                return new DescribeResult(preparedStmt.parameterTypes(), analyzedStatement.outputs(), this.resolveTableFromSelect(analyzedStatement));
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + type));
    }

    @Nullable
    private RelationInfo resolveTableFromSelect(AnalyzedStatement stmt) {
        QueriedSelectRelation relation;
        List<AnalyzedRelation> from;
        if (stmt instanceof QueriedSelectRelation && (from = (relation = (QueriedSelectRelation)stmt).from()).size() == 1 && from.get(0) instanceof AbstractTableRelation) {
            return ((AbstractTableRelation)from.get(0)).tableInfo();
        }
        return null;
    }

    @Nullable
    public CompletableFuture<?> execute(String portalName, int maxRows, ResultReceiver<?> resultReceiver) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=execute portalName={} maxRows={}", (Object)portalName, (Object)maxRows);
        }
        Portal portal = this.getSafePortal(portalName);
        AnalyzedStatement analyzedStmt = portal.analyzedStatement();
        if (this.isReadOnly && analyzedStmt.isWriteOperation()) {
            throw new ReadOnlyException(portal.preparedStmt().rawStatement());
        }
        if (analyzedStmt instanceof AnalyzedBegin) {
            this.currentTransactionState = TransactionState.IN_TRANSACTION;
            resultReceiver.allFinished(false);
        } else {
            if (analyzedStmt instanceof AnalyzedCommit) {
                this.currentTransactionState = TransactionState.IDLE;
                resultReceiver.allFinished(false);
                return resultReceiver.completionFuture();
            }
            if (analyzedStmt instanceof AnalyzedDeallocate) {
                String stmtToDeallocate = ((AnalyzedDeallocate)analyzedStmt).preparedStmtName();
                if (stmtToDeallocate != null) {
                    this.close((byte)83, stmtToDeallocate);
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("deallocating all prepared statements");
                    }
                    this.preparedStatements.clear();
                }
                resultReceiver.allFinished(false);
            } else if (analyzedStmt instanceof AnalyzedDiscard) {
                AnalyzedDiscard discard = (AnalyzedDiscard)analyzedStmt;
                if (discard.target() == DiscardStatement.Target.ALL) {
                    this.close();
                }
                resultReceiver.allFinished(false);
            } else if (analyzedStmt.isWriteOperation()) {
                this.deferredExecutionsByStmt.compute(portal.preparedStmt().parsedStatement(), (key, oldValue) -> {
                    DeferredExecution deferredExecution = new DeferredExecution(portal, maxRows, resultReceiver);
                    if (oldValue == null) {
                        ArrayList<DeferredExecution> deferredExecutions = new ArrayList<DeferredExecution>();
                        deferredExecutions.add(deferredExecution);
                        return deferredExecutions;
                    }
                    oldValue.add(deferredExecution);
                    return oldValue;
                });
            } else {
                if (!this.deferredExecutionsByStmt.isEmpty()) {
                    throw new UnsupportedOperationException("Only write operations are allowed in Batch statements");
                }
                this.activeExecution = this.activeExecution == null ? this.singleExec(portal, resultReceiver, maxRows) : this.activeExecution.thenCompose(ignored -> this.singleExec(portal, resultReceiver, maxRows));
                return this.activeExecution;
            }
        }
        return null;
    }

    public void flush() {
        assert (!this.deferredExecutionsByStmt.isEmpty()) : "Session.flush() must only be called if there are deferred executions";
        this.activeExecution = this.triggerDeferredExecutions();
    }

    public CompletableFuture<?> sync() {
        if (this.activeExecution == null) {
            return this.triggerDeferredExecutions();
        }
        CompletableFuture<?> result = this.activeExecution;
        this.activeExecution = null;
        return result;
    }

    private CompletableFuture<?> triggerDeferredExecutions() {
        switch (this.deferredExecutionsByStmt.size()) {
            case 0: {
                LOGGER.debug("method=sync deferredExecutions=0");
                return CompletableFuture.completedFuture(null);
            }
            case 1: {
                Map.Entry<Statement, List<DeferredExecution>> entry = this.deferredExecutionsByStmt.entrySet().iterator().next();
                this.deferredExecutionsByStmt.clear();
                return this.exec(entry.getKey(), entry.getValue());
            }
        }
        List<CompletableFuture> futures = Lists2.map(this.deferredExecutionsByStmt.entrySet(), x -> this.exec((Statement)x.getKey(), (List)x.getValue()));
        this.deferredExecutionsByStmt.clear();
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private CompletableFuture<?> exec(Statement statement, List<DeferredExecution> executions) {
        if (executions.size() == 1) {
            DeferredExecution toExec = executions.get(0);
            return this.singleExec(toExec.portal(), toExec.resultReceiver(), toExec.maxRows());
        }
        return this.bulkExec(statement, executions);
    }

    private CompletableFuture<?> bulkExec(Statement statement, List<DeferredExecution> toExec) {
        Plan plan;
        assert (toExec.size() >= 1) : "Must have at least 1 deferred execution for bulk exec";
        UUID jobId = UUID.randomUUID();
        RoutingProvider routingProvider = new RoutingProvider(Randomness.get().nextInt(), this.planner.getAwarenessAttributes());
        ClusterState clusterState = this.executor.clusterService().state();
        CoordinatorTxnCtx txnCtx = new CoordinatorTxnCtx(this.sessionContext);
        PlannerContext plannerContext = new PlannerContext(clusterState, routingProvider, jobId, txnCtx, this.nodeCtx, 0, null);
        PreparedStmt firstPreparedStatement = toExec.get(0).portal().preparedStmt();
        AnalyzedStatement analyzedStatement = firstPreparedStatement.analyzedStatement();
        try {
            plan = this.planner.plan(analyzedStatement, plannerContext);
        }
        catch (Throwable t2) {
            this.jobsLogs.logPreExecutionFailure(jobId, firstPreparedStatement.rawStatement(), SQLExceptions.messageOf(t2), this.sessionContext.sessionUser());
            throw t2;
        }
        this.jobsLogs.logExecutionStart(jobId, firstPreparedStatement.rawStatement(), this.sessionContext.sessionUser(), StatementClassifier.classify(plan));
        List<Row> bulkArgs = Lists2.map(toExec, x -> new RowN(x.portal().params().toArray()));
        List<CompletableFuture<Long>> rowCounts = plan.executeBulk(this.executor, plannerContext, bulkArgs, SubQueryResults.EMPTY);
        CompletableFuture<Void> allRowCounts = CompletableFuture.allOf(rowCounts.toArray(new CompletableFuture[0]));
        List<CompletableFuture> resultReceiverFutures = Lists2.map(toExec, x -> x.resultReceiver().completionFuture());
        CompletableFuture<Void> allResultReceivers = CompletableFuture.allOf(resultReceiverFutures.toArray(new CompletableFuture[0]));
        return ((CompletableFuture)((CompletableFuture)allRowCounts.exceptionally(t -> null)).thenAccept(ignored -> Session.emitRowCountsToResultReceivers(jobId, this.jobsLogs, toExec, rowCounts))).runAfterBoth(allResultReceivers, () -> {});
    }

    private static void emitRowCountsToResultReceivers(UUID jobId, JobsLogs jobsLogs, List<DeferredExecution> executions, List<CompletableFuture<Long>> completedRowCounts) {
        Object[] cells = new Long[1];
        RowN row = new RowN(cells);
        for (int i = 0; i < completedRowCounts.size(); ++i) {
            CompletableFuture<Long> completedRowCount = completedRowCounts.get(i);
            ResultReceiver<?> resultReceiver = executions.get(i).resultReceiver();
            try {
                Long rowCount = completedRowCount.join();
                cells[0] = rowCount == null ? -2L : rowCount;
            }
            catch (Throwable t) {
                cells[0] = -2L;
            }
            resultReceiver.setNextRow(row);
            resultReceiver.allFinished(false);
        }
        jobsLogs.logExecutionEnd(jobId, null);
    }

    @VisibleForTesting
    CompletableFuture<?> singleExec(Portal portal, ResultReceiver<?> resultReceiver, int maxRows) {
        Plan plan;
        RowConsumerToResultReceiver activeConsumer = portal.activeConsumer();
        if (activeConsumer != null && activeConsumer.suspended()) {
            activeConsumer.replaceResultReceiver(resultReceiver, maxRows);
            activeConsumer.resume();
            return resultReceiver.completionFuture();
        }
        UUID jobId = UUID.randomUUID();
        RoutingProvider routingProvider = new RoutingProvider(Randomness.get().nextInt(), this.planner.getAwarenessAttributes());
        ClusterState clusterState = this.executor.clusterService().state();
        CoordinatorTxnCtx txnCtx = new CoordinatorTxnCtx(this.sessionContext);
        NodeContext nodeCtx = this.executor.nodeContext();
        RowN params = new RowN(portal.params().toArray());
        PlannerContext plannerContext = new PlannerContext(clusterState, routingProvider, jobId, txnCtx, nodeCtx, maxRows, params);
        AnalyzedStatement analyzedStmt = portal.analyzedStatement();
        String rawStatement = portal.preparedStmt().rawStatement();
        if (analyzedStmt == null) {
            String errorMsg = "Statement must have been analyzed: " + rawStatement;
            this.jobsLogs.logPreExecutionFailure(jobId, rawStatement, errorMsg, this.sessionContext.sessionUser());
            throw new IllegalStateException(errorMsg);
        }
        try {
            plan = this.planner.plan(analyzedStmt, plannerContext);
        }
        catch (Throwable t) {
            this.jobsLogs.logPreExecutionFailure(jobId, rawStatement, SQLExceptions.messageOf(t), this.sessionContext.sessionUser());
            throw t;
        }
        if (!analyzedStmt.isWriteOperation()) {
            resultReceiver = new RetryOnFailureResultReceiver(this.executor.clusterService(), clusterState, indexName -> this.executor.clusterService().state().metadata().hasIndex((String)indexName), resultReceiver, jobId, (newJobId, resultRec) -> this.retryQuery((UUID)newJobId, analyzedStmt, routingProvider, new RowConsumerToResultReceiver((ResultReceiver)resultRec, maxRows, new JobsLogsUpdateListener((UUID)newJobId, this.jobsLogs)), params, txnCtx, nodeCtx));
        }
        this.jobsLogs.logExecutionStart(jobId, rawStatement, this.sessionContext.sessionUser(), StatementClassifier.classify(plan));
        RowConsumerToResultReceiver consumer = new RowConsumerToResultReceiver(resultReceiver, maxRows, new JobsLogsUpdateListener(jobId, this.jobsLogs));
        portal.setActiveConsumer(consumer);
        plan.execute(this.executor, plannerContext, consumer, params, SubQueryResults.EMPTY);
        return resultReceiver.completionFuture();
    }

    @Nullable
    public List<? extends DataType> getOutputTypes(String portalName) {
        Portal portal = this.getSafePortal(portalName);
        AnalyzedStatement analyzedStatement = portal.analyzedStatement();
        List<Symbol> fields = analyzedStatement.outputs();
        if (fields != null) {
            return Symbols.typeView(fields);
        }
        return null;
    }

    public String getQuery(String portalName) {
        return this.getSafePortal(portalName).preparedStmt().rawStatement();
    }

    public DataType<?> getParamType(String statementName, int idx) {
        PreparedStmt stmt = this.getSafeStmt(statementName);
        return stmt.getEffectiveParameterType(idx);
    }

    private PreparedStmt getSafeStmt(String statementName) {
        PreparedStmt preparedStmt = this.preparedStatements.get(statementName);
        if (preparedStmt == null) {
            throw new IllegalArgumentException("No statement found with name: " + statementName);
        }
        return preparedStmt;
    }

    @Nullable
    public FormatCodes.FormatCode[] getResultFormatCodes(String portal) {
        return this.getSafePortal(portal).resultFormatCodes();
    }

    public void close(byte type, String name) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=close type={} name={}", (Object)Character.valueOf((char)type), (Object)name);
        }
        switch (type) {
            case 80: {
                Portal portal = this.portals.remove(name);
                if (portal != null) {
                    portal.closeActiveConsumer();
                }
                return;
            }
            case 83: {
                PreparedStmt preparedStmt = this.preparedStatements.remove(name);
                if (preparedStmt != null) {
                    Iterator<Map.Entry<String, Portal>> it = this.portals.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, Portal> entry = it.next();
                        Portal portal = entry.getValue();
                        if (!portal.preparedStmt().equals(preparedStmt)) continue;
                        portal.closeActiveConsumer();
                        it.remove();
                    }
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type + ", valid types are: [P, S]");
    }

    @Override
    public void close() {
        this.currentTransactionState = TransactionState.IDLE;
        this.resetDeferredExecutions();
        this.activeExecution = null;
        for (Portal portal : this.portals.values()) {
            portal.closeActiveConsumer();
        }
        this.portals.clear();
        this.preparedStatements.clear();
    }

    public boolean hasDeferredExecutions() {
        return !this.deferredExecutionsByStmt.isEmpty();
    }

    public void resetDeferredExecutions() {
        for (List<DeferredExecution> deferredExecutions : this.deferredExecutionsByStmt.values()) {
            for (DeferredExecution deferredExecution : deferredExecutions) {
                deferredExecution.portal().closeActiveConsumer();
                this.portals.remove(deferredExecution.portal().name());
            }
        }
        this.deferredExecutionsByStmt.clear();
    }

    public TransactionState transactionState() {
        return this.currentTransactionState;
    }
}

