/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action.sql;

import io.crate.action.sql.Session;
import io.crate.action.sql.SessionContext;
import io.crate.analyze.Analyzer;
import io.crate.auth.user.User;
import io.crate.auth.user.UserManager;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.metadata.NodeContext;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Planner;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.NodeDisconnectedException;

@Singleton
public class SQLOperations {
    public static final Setting<Boolean> NODE_READ_ONLY_SETTING = Setting.boolSetting("node.sql.read_only", false, Setting.Property.NodeScope);
    private final NodeContext nodeCtx;
    private final Analyzer analyzer;
    private final Planner planner;
    private final Provider<DependencyCarrier> executorProvider;
    private final JobsLogs jobsLogs;
    private final ClusterService clusterService;
    private final UserManager userManager;
    private final boolean isReadOnly;
    private volatile boolean disabled;

    @Inject
    public SQLOperations(NodeContext nodeCtx, Analyzer analyzer, Planner planner, Provider<DependencyCarrier> executorProvider, JobsLogs jobsLogs, Settings settings, ClusterService clusterService, Provider<UserManager> userManagerProvider) {
        this.nodeCtx = nodeCtx;
        this.analyzer = analyzer;
        this.planner = planner;
        this.executorProvider = executorProvider;
        this.jobsLogs = jobsLogs;
        this.clusterService = clusterService;
        this.userManager = userManagerProvider.get();
        this.isReadOnly = NODE_READ_ONLY_SETTING.get(settings);
    }

    private Session createSession(SessionContext sessionContext) {
        if (this.disabled) {
            throw new NodeDisconnectedException(this.clusterService.localNode(), "sql");
        }
        return new Session(this.nodeCtx, this.analyzer, this.planner, this.jobsLogs, this.isReadOnly, this.executorProvider.get(), this.userManager.getAccessControl(sessionContext), sessionContext);
    }

    public Session newSystemSession() {
        return this.createSession(SessionContext.systemSessionContext());
    }

    public Session createSession(@Nullable String defaultSchema, User authenticatedUser) {
        SessionContext sessionContext = defaultSchema == null ? new SessionContext(authenticatedUser, new String[0]) : new SessionContext(authenticatedUser, defaultSchema);
        return this.createSession(sessionContext);
    }

    public void disable() {
        this.disabled = true;
    }

    public void enable() {
        this.disabled = false;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }
}

