/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action.sql;

import io.crate.action.sql.ResultReceiver;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.SQLExceptions;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class RowConsumerToResultReceiver
implements RowConsumer {
    private final CompletableFuture<?> completionFuture = new CompletableFuture();
    private ResultReceiver resultReceiver;
    private int maxRows;
    private long rowCount = 0L;
    private BatchIterator<Row> activeIt;

    public RowConsumerToResultReceiver(ResultReceiver resultReceiver, int maxRows, Consumer<Throwable> onCompletion) {
        this.resultReceiver = resultReceiver;
        this.maxRows = maxRows;
        this.completionFuture.whenComplete((res, err) -> onCompletion.accept((Throwable)err));
    }

    @Override
    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (failure == null) {
            this.consumeIt(iterator);
        } else {
            if (iterator != null) {
                iterator.close();
            }
            this.completionFuture.completeExceptionally(failure);
            this.resultReceiver.fail(failure);
        }
    }

    @Override
    public CompletableFuture<?> completionFuture() {
        return this.completionFuture;
    }

    private void consumeIt(BatchIterator<Row> iterator) {
        try {
            while (iterator.moveNext()) {
                ++this.rowCount;
                this.resultReceiver.setNextRow(iterator.currentElement());
                if (this.maxRows <= 0 || this.rowCount % (long)this.maxRows != 0L) continue;
                this.activeIt = iterator;
                this.resultReceiver.batchFinished();
                return;
            }
            if (iterator.allLoaded()) {
                this.completionFuture.complete(null);
                iterator.close();
                this.resultReceiver.allFinished(false);
            } else {
                iterator.loadNextBatch().whenComplete((r, f) -> {
                    if (f == null) {
                        this.consumeIt(iterator);
                    } else {
                        Throwable t = SQLExceptions.unwrap(f);
                        iterator.close();
                        this.completionFuture.completeExceptionally(t);
                        this.resultReceiver.fail(t);
                    }
                });
            }
        }
        catch (Throwable t) {
            iterator.close();
            this.completionFuture.completeExceptionally(t);
            this.resultReceiver.fail(t);
        }
    }

    public void closeAndFinishIfSuspended() {
        if (this.activeIt != null) {
            this.activeIt.close();
            this.completionFuture.complete(null);
            this.resultReceiver.allFinished(true);
        }
    }

    public boolean suspended() {
        return this.activeIt != null;
    }

    public void replaceResultReceiver(ResultReceiver resultReceiver, int maxRows) {
        this.resultReceiver = resultReceiver;
        this.maxRows = maxRows;
    }

    public void resume() {
        assert (this.activeIt != null) : "resume must only be called if suspended() returned true and activeIt is not null";
        BatchIterator<Row> iterator = this.activeIt;
        this.activeIt = null;
        this.consumeIt(iterator);
    }

    public String toString() {
        return "RowConsumerToResultReceiver{resultReceiver=" + this.resultReceiver + ", maxRows=" + this.maxRows + ", rowCount=" + this.rowCount + ", activeIt=" + this.activeIt + "}";
    }
}

