/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action.sql;

import io.crate.analyze.AnalyzedStatement;
import io.crate.sql.tree.Statement;
import io.crate.types.DataType;

public class PreparedStmt {
    private final AnalyzedStatement analyzedStatement;
    private final Statement parsedStatement;
    private final String rawStatement;
    private final DataType[] describedParameterTypes;

    PreparedStmt(Statement parsedStatement, AnalyzedStatement analyzedStatement, String query, DataType[] parameterTypes) {
        this.parsedStatement = parsedStatement;
        this.analyzedStatement = analyzedStatement;
        this.rawStatement = query;
        this.describedParameterTypes = parameterTypes;
    }

    public AnalyzedStatement analyzedStatement() {
        return this.analyzedStatement;
    }

    Statement parsedStatement() {
        return this.parsedStatement;
    }

    DataType[] parameterTypes() {
        return this.describedParameterTypes;
    }

    DataType<?> getEffectiveParameterType(int idx) {
        if (idx >= this.describedParameterTypes.length) {
            throw new IllegalArgumentException("Requested parameter index exceeds the number of parameters: " + idx);
        }
        return this.describedParameterTypes[idx];
    }

    public String rawStatement() {
        return this.rawStatement;
    }
}

