/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action.sql;

import io.crate.analyze.Relations;
import io.crate.expression.symbol.DefaultTraversalSymbolVisitor;
import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.types.DataType;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

class ParameterTypeExtractor
extends DefaultTraversalSymbolVisitor<Void, Void>
implements Consumer<Symbol> {
    private final SortedSet<ParameterSymbol> parameterSymbols = new TreeSet<ParameterSymbol>(Comparator.comparing(ParameterSymbol::index));

    ParameterTypeExtractor() {
    }

    @Override
    public void accept(Symbol symbol) {
        symbol.accept(this, null);
    }

    @Override
    public Void visitSelectSymbol(SelectSymbol selectSymbol, Void context) {
        Relations.traverseDeepSymbols(selectSymbol.relation(), this);
        return null;
    }

    @Override
    public Void visitParameterSymbol(ParameterSymbol parameterSymbol, Void context) {
        this.parameterSymbols.add(parameterSymbol);
        return null;
    }

    DataType<?>[] getParameterTypes(@Nonnull Consumer<Consumer<? super Symbol>> consumer) {
        consumer.accept(this);
        if (!this.parameterSymbols.isEmpty() && this.parameterSymbols.last().index() != this.parameterSymbols.size() - 1) {
            throw new IllegalStateException("The assembled list of ParameterSymbols is invalid. Missing parameters.");
        }
        DataType[] dataTypes = (DataType[])this.parameterSymbols.stream().map(ParameterSymbol::getBoundType).toArray(DataType[]::new);
        this.parameterSymbols.clear();
        return dataTypes;
    }
}

