/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action.sql;

import io.crate.analyze.AnalyzedPrivileges;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.auth.user.UserManager;
import io.crate.data.Row;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class DCLStatementDispatcher
implements BiFunction<AnalyzedStatement, Row, CompletableFuture<Long>> {
    private final InnerVisitor INNER_VISITOR = new InnerVisitor();
    private final UserManager userManager;

    @Inject
    public DCLStatementDispatcher(Provider<UserManager> userManagerProvider) {
        this.userManager = userManagerProvider.get();
    }

    @Override
    public CompletableFuture<Long> apply(AnalyzedStatement analyzedStatement, Row row) {
        return analyzedStatement.accept(this.INNER_VISITOR, this.userManager);
    }

    private static class InnerVisitor
    extends AnalyzedStatementVisitor<UserManager, CompletableFuture<Long>> {
        private InnerVisitor() {
        }

        @Override
        protected CompletableFuture<Long> visitAnalyzedStatement(AnalyzedStatement analyzedStatement, UserManager userManager) {
            return CompletableFuture.failedFuture(new UnsupportedOperationException(String.format(Locale.ENGLISH, "Can't handle \"%s\"", analyzedStatement)));
        }

        @Override
        public CompletableFuture<Long> visitPrivilegesStatement(AnalyzedPrivileges analysis, UserManager userManager) {
            return userManager.applyPrivileges(analysis.userNames(), analysis.privileges());
        }
    }
}

