/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action;

import io.crate.common.unit.TimeValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.elasticsearch.action.bulk.BackoffPolicy;

public class LimitedExponentialBackoff
extends BackoffPolicy {
    private final int firstDelayInMS;
    private final int maxIterations;
    private final int maxDelayInMS;

    public LimitedExponentialBackoff(int firstDelayInMS, int maxIterations, int maxDelayInMS) {
        assert (firstDelayInMS >= 0) : "firstDelayInMS should be >= 0";
        assert (maxIterations > 0) : "maxIterations should be > 0";
        assert (maxDelayInMS > 0) : "maxDelayInMS should be > 0";
        this.firstDelayInMS = firstDelayInMS;
        this.maxIterations = maxIterations;
        this.maxDelayInMS = maxDelayInMS;
    }

    public static BackoffPolicy limitedExponential(int maxDelayInMS) {
        return new LimitedExponentialBackoff(10, Integer.MAX_VALUE, maxDelayInMS);
    }

    @Override
    public Iterator<TimeValue> iterator() {
        return new LimitedExponentialBackoffIterator(this.firstDelayInMS, this.maxIterations, this.maxDelayInMS);
    }

    private static class LimitedExponentialBackoffIterator
    implements Iterator<TimeValue> {
        private static final float FACTOR = 1.8f;
        private final int firstDelayInMS;
        private final int maxIterations;
        private final int mayDelayInMS;
        private int currentIterations = 0;

        private LimitedExponentialBackoffIterator(int firstDelayInMS, int maxIterations, int maxDelayInMs) {
            this.firstDelayInMS = firstDelayInMS;
            this.maxIterations = maxIterations;
            this.mayDelayInMS = maxDelayInMs;
        }

        private int calculate(int iteration) {
            return Math.min(this.mayDelayInMS, (int)Math.pow((double)iteration / Math.E, 1.8f));
        }

        @Override
        public boolean hasNext() {
            return this.currentIterations < this.maxIterations;
        }

        @Override
        public TimeValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Reached maximum amount of backoff iterations. Only " + this.maxIterations + " iterations allowed.");
            }
            int result = this.firstDelayInMS + this.calculate(this.currentIterations);
            ++this.currentIterations;
            return TimeValue.timeValueMillis(result);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported for " + LimitedExponentialBackoff.class.getSimpleName());
        }
    }
}

