/*
 * Decompiled with CFR 0.152.
 */
package io.crate.action;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;

public class FutureActionListener<Response, Result>
extends CompletableFuture<Result>
implements ActionListener<Response> {
    private final Function<? super Response, ? extends Result> transformFunction;

    public static <T> FutureActionListener<T, T> newInstance() {
        return new FutureActionListener(Function.identity());
    }

    public FutureActionListener(Function<? super Response, ? extends Result> transformFunction) {
        this.transformFunction = transformFunction;
    }

    @Override
    public void onResponse(Response response) {
        try {
            this.complete(this.transformFunction.apply(response));
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
    }

    @Override
    public void onFailure(Exception e) {
        this.completeExceptionally(e);
    }
}

