/*
 * Decompiled with CFR 0.152.
 */
package io.crate.operation.language;

import io.crate.data.Input;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;

class PolyglotValuesConverter {
    private static final TypeLiteral<Number> NUMBER_TYPE_LITERAL = new TypeLiteral<Number>(){};
    private static final TypeLiteral<Map> MAP_TYPE_LITERAL = new TypeLiteral<Map>(){};

    PolyglotValuesConverter() {
    }

    static Object toCrateObject(Value value, DataType<?> type) {
        if (value == null) {
            return null;
        }
        switch (type.id()) {
            case 100: {
                ArrayList<Object> items = new ArrayList<Object>((int)value.getArraySize());
                int idx = 0;
                while ((long)idx < value.getArraySize()) {
                    Object item = PolyglotValuesConverter.toCrateObject(value.getArrayElement((long)idx), ((ArrayType)type).innerType());
                    items.add(idx, item);
                    ++idx;
                }
                return type.implicitCast(items);
            }
            case 12: {
                return type.implicitCast(value.as(MAP_TYPE_LITERAL));
            }
            case 13: {
                if (value.hasArrayElements()) {
                    return type.implicitCast(PolyglotValuesConverter.toCrateObject(value, DataTypes.DOUBLE_ARRAY));
                }
                return type.implicitCast((Object)value.asString());
            }
            case 14: {
                if (value.isString()) {
                    return type.implicitCast((Object)value.asString());
                }
                return type.implicitCast(value.as(MAP_TYPE_LITERAL));
            }
        }
        Object polyglotValue = value.isNumber() ? value.as(NUMBER_TYPE_LITERAL) : (value.isString() ? value.asString() : (value.isBoolean() ? Boolean.valueOf(value.asBoolean()) : value.asString()));
        return type.implicitCast(polyglotValue);
    }

    static Object[] toPolyglotValues(Input<Object>[] inputs, List<DataType<?>> dataTypes) {
        Object[] args = new Object[inputs.length];
        block3: for (int i = 0; i < inputs.length; ++i) {
            switch (dataTypes.get(i).id()) {
                case 12: 
                case 14: {
                    args[i] = ProxyObject.fromMap((Map)((Map)inputs[i].value()));
                    continue block3;
                }
                default: {
                    args[i] = Value.asValue((Object)inputs[i].value());
                }
            }
        }
        return args;
    }
}

