/*
 * Decompiled with CFR 0.152.
 */
package io.crate.operation.language;

import io.crate.common.collections.Lists2;
import io.crate.data.Input;
import io.crate.exceptions.ScriptException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.operation.language.JavaScriptLanguage;
import io.crate.operation.language.PolyglotValuesConverter;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;

public class JavaScriptUserDefinedFunction
extends Scalar<Object, Object> {
    private final Signature signature;
    private final String script;

    JavaScriptUserDefinedFunction(Signature signature, String script) {
        this.signature = signature;
        this.script = script;
    }

    public Scalar<Object, Object> compile(List<Symbol> arguments) {
        try {
            return new CompiledFunction(JavaScriptLanguage.resolvePolyglotFunctionValue(this.signature.getName().name(), this.script));
        }
        catch (IOException | PolyglotException e) {
            throw new ScriptException("compile error", e, "javascript");
        }
    }

    public Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        try {
            Value function = JavaScriptLanguage.resolvePolyglotFunctionValue(this.signature.getName().name(), this.script);
            Object[] polyglotValueArgs = PolyglotValuesConverter.toPolyglotValues(args, Lists2.map((Collection)this.signature.getArgumentTypes(), TypeSignature::createType));
            return PolyglotValuesConverter.toCrateObject(function.execute(polyglotValueArgs), this.signature.getReturnType().createType());
        }
        catch (IOException | PolyglotException e) {
            throw new ScriptException(e.getLocalizedMessage(), e, "javascript");
        }
    }

    public Signature signature() {
        return this.signature;
    }

    public Signature boundSignature() {
        return this.signature();
    }

    private static Object toCrateObject(Value value, DataType<?> type) {
        if ("undefined".equalsIgnoreCase(value.getClass().getSimpleName())) {
            return null;
        }
        return PolyglotValuesConverter.toCrateObject(value, type);
    }

    private class CompiledFunction
    extends Scalar<Object, Object> {
        private final Value function;

        private CompiledFunction(Value function) {
            this.function = function;
        }

        public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
            Object[] polyglotValueArgs = PolyglotValuesConverter.toPolyglotValues(args, Lists2.map((Collection)JavaScriptUserDefinedFunction.this.signature.getArgumentTypes(), TypeSignature::createType));
            try {
                return JavaScriptUserDefinedFunction.toCrateObject(this.function.execute(polyglotValueArgs), JavaScriptUserDefinedFunction.this.signature.getReturnType().createType());
            }
            catch (PolyglotException e) {
                throw new ScriptException(e.getLocalizedMessage(), (Throwable)e, "javascript");
            }
        }

        public Signature signature() {
            return JavaScriptUserDefinedFunction.this.signature;
        }

        public Signature boundSignature() {
            return JavaScriptUserDefinedFunction.this.signature;
        }
    }
}

