/*
 * Decompiled with CFR 0.152.
 */
package io.crate.operation.language;

import io.crate.expression.udf.UDFLanguage;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.expression.udf.UserDefinedFunctionService;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.Signature;
import io.crate.operation.language.JavaScriptUserDefinedFunction;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import org.elasticsearch.common.inject.Inject;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class JavaScriptLanguage
implements UDFLanguage {
    static final String NAME = "javascript";
    private static final Engine ENGINE = Engine.newBuilder().build();
    private static final HostAccess HOST_ACCESS = HostAccess.newBuilder().allowListAccess(true).allowArrayAccess(true).build();

    @Inject
    public JavaScriptLanguage(UserDefinedFunctionService udfService) {
        udfService.registerLanguage((UDFLanguage)this);
    }

    public Scalar createFunctionImplementation(UserDefinedFunctionMetadata meta, Signature signature) throws ScriptException {
        return new JavaScriptUserDefinedFunction(signature, meta.definition());
    }

    @Nullable
    public String validate(UserDefinedFunctionMetadata meta) {
        try {
            JavaScriptLanguage.resolvePolyglotFunctionValue(meta.name(), meta.definition());
            return null;
        }
        catch (IOException | IllegalArgumentException | PolyglotException t) {
            return String.format(Locale.ENGLISH, "Invalid JavaScript in function '%s.%s(%s)' AS '%s': %s", meta.schema(), meta.name(), meta.argumentTypes().stream().map(DataType::getName).collect(Collectors.joining(", ")), meta.definition(), t.getMessage());
        }
    }

    static Value resolvePolyglotFunctionValue(String functionName, String script) throws IOException {
        Context context = Context.newBuilder((String[])new String[]{"js"}).engine(ENGINE).allowHostAccess(HOST_ACCESS).build();
        Source source = Source.newBuilder((String)"js", (CharSequence)script, (String)functionName).build();
        context.eval(source);
        Value polyglotFunctionValue = context.getBindings("js").getMember(functionName);
        if (polyglotFunctionValue == null) {
            throw new IllegalArgumentException("The name of the function signature '" + functionName + "' doesn't match the function name in the function definition.");
        }
        return polyglotFunctionValue;
    }

    public String name() {
        return NAME;
    }
}

