/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.ssl;

import io.crate.protocols.ssl.SslConfiguration;
import io.crate.protocols.ssl.SslContextProvider;
import io.netty.handler.ssl.SslContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;

@Singleton
public class SslContextProviderImpl
implements SslContextProvider {
    private static final Logger LOGGER = LogManager.getLogger(SslContextProvider.class);
    private volatile SslContext sslContext;
    private final Settings settings;

    @Inject
    public SslContextProviderImpl(Settings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SslContext getSslContext() {
        SslContext localRef = this.sslContext;
        if (localRef == null) {
            SslContextProviderImpl sslContextProviderImpl = this;
            synchronized (sslContextProviderImpl) {
                localRef = this.sslContext;
                if (localRef == null) {
                    this.sslContext = localRef = SslConfiguration.buildSslContext(this.settings);
                }
            }
        }
        return localRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSslContext() {
        SslContextProviderImpl sslContextProviderImpl = this;
        synchronized (sslContextProviderImpl) {
            this.sslContext = SslConfiguration.buildSslContext(this.settings);
            LOGGER.info("SSL configuration is reloaded.");
        }
    }
}

