/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.ssl;

import io.crate.auth.AuthSettings;
import io.crate.common.Optionals;
import io.crate.protocols.ssl.SslConfigSettings;
import io.crate.protocols.ssl.SslConfigurationException;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.common.settings.Settings;

public final class SslConfiguration {
    private SslConfiguration() {
    }

    static KeyStore loadKeyStore(String path, char[] pass) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(path));){
            keyStore.load(stream, pass);
        }
        return keyStore;
    }

    static KeyManager[] createKeyManagers(KeyStore keyStore, char[] pass) throws Exception {
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyFactory.init(keyStore, pass);
        return keyFactory.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers(KeyStore keyStore) {
        TrustManagerFactory trustFactory;
        try {
            trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(keyStore);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return trustFactory.getTrustManagers();
    }

    private static <T> T[] concat(T[] xs, T[] ys) {
        T[] result = Arrays.copyOf(xs, xs.length + ys.length);
        System.arraycopy(ys, 0, result, xs.length, ys.length);
        return result;
    }

    static X509Certificate[] getRootCertificates(KeyStore keyStore) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate cert;
                String alias = aliases.nextElement();
                if (!keyStore.isCertificateEntry(alias) || (cert = (X509Certificate)keyStore.getCertificate(alias)) == null) continue;
                certs.add(cert);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return certs.toArray(new X509Certificate[0]);
    }

    static X509Certificate[] getCertificateChain(KeyStore keyStore) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate[] certificateChain;
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias) || (certificateChain = keyStore.getCertificateChain(alias)) == null) continue;
                for (Certificate certificate : certificateChain) {
                    certs.add((X509Certificate)certificate);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return certs.toArray(new X509Certificate[0]);
    }

    static PrivateKey getPrivateKey(KeyStore keyStore, char[] password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            Key key;
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias) || !((key = keyStore.getKey(alias, password)) instanceof PrivateKey)) continue;
            return (PrivateKey)key;
        }
        throw new KeyStoreException("No fitting private key found in keyStore");
    }

    public static SslContext buildSslContext(Settings settings) {
        String keystorePath = (String)SslConfigSettings.SSL_KEYSTORE_FILEPATH.setting().get(settings);
        char[] keystorePass = ((String)SslConfigSettings.SSL_KEYSTORE_PASSWORD.setting().get(settings)).toCharArray();
        char[] keystoreKeyPass = ((String)SslConfigSettings.SSL_KEYSTORE_KEY_PASSWORD.setting().get(settings)).toCharArray();
        String trustStorePath = (String)SslConfigSettings.SSL_TRUSTSTORE_FILEPATH.setting().get(settings);
        char[] trustStorePass = ((String)SslConfigSettings.SSL_TRUSTSTORE_PASSWORD.setting().get(settings)).toCharArray();
        try {
            KeyStore keyStore = SslConfiguration.loadKeyStore(keystorePath, keystorePass);
            KeyManager[] keyManagers = SslConfiguration.createKeyManagers(keyStore, keystoreKeyPass);
            Optional trustStore = Optionals.of(() -> SslConfiguration.loadKeyStore(trustStorePath, trustStorePass));
            TrustManager[] trustManagers = trustStore.map(SslConfiguration::createTrustManagers).orElseGet(() -> new TrustManager[0]);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagers, trustManagers, null);
            X509Certificate[] keyStoreRootCerts = SslConfiguration.getRootCertificates(keyStore);
            X509Certificate[] keyStoreCertChain = SslConfiguration.getCertificateChain(keyStore);
            X509Certificate[] trustStoreRootCerts = trustStore.map(SslConfiguration::getRootCertificates).orElseGet(() -> new X509Certificate[0]);
            PrivateKey privateKey = SslConfiguration.getPrivateKey(keyStore, keystoreKeyPass);
            return SslContextBuilder.forServer((PrivateKey)privateKey, (X509Certificate[])keyStoreCertChain).ciphers(List.of(sslContext.createSSLEngine().getEnabledCipherSuites())).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).clientAuth(AuthSettings.resolveClientAuth((Settings)settings)).trustManager(SslConfiguration.concat(keyStoreRootCerts, trustStoreRootCerts)).sessionCacheSize(0L).sessionTimeout(0L).startTls(false).sslProvider(SslProvider.JDK).build();
        }
        catch (SslConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SslConfigurationException("Failed to build SSL configuration: " + e.getMessage(), e);
        }
    }
}

