/*
 * Decompiled with CFR 0.152.
 */
package io.crate.azure.plugin;

import io.crate.azure.AzureConfiguration;
import io.crate.azure.discovery.AzureSeedHostsProvider;
import io.crate.azure.management.AzureComputeService;
import io.crate.azure.management.AzureComputeServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class AzureDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin {
    private final Settings settings;
    private AzureComputeServiceImpl azureComputeService;
    protected final Logger logger = LogManager.getLogger(AzureDiscoveryPlugin.class);

    public AzureDiscoveryPlugin(Settings settings) {
        this.settings = settings;
    }

    private AzureComputeService azureComputeService() {
        if (this.azureComputeService == null) {
            this.azureComputeService = new AzureComputeServiceImpl(this.settings);
        }
        return this.azureComputeService;
    }

    public String name() {
        return "crate-azure-discovery";
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(AzureComputeService.Management.SUBSCRIPTION_ID, AzureComputeService.Management.RESOURCE_GROUP_NAME, AzureComputeService.Management.TENANT_ID, AzureComputeService.Management.APP_ID, AzureComputeService.Management.APP_SECRET, AzureComputeService.Discovery.REFRESH, AzureComputeService.Discovery.HOST_TYPE, AzureComputeService.Discovery.DISCOVERY_METHOD);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        if (AzureConfiguration.isDiscoveryReady(this.settings, this.logger)) {
            return Collections.singletonList(this.azureComputeService());
        }
        return Collections.emptyList();
    }

    public Map<String, Supplier<SeedHostsProvider>> getSeedHostProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap("azure", () -> {
            if (AzureConfiguration.isDiscoveryReady(this.settings, this.logger)) {
                return new AzureSeedHostsProvider(this.settings, this.azureComputeService(), transportService, networkService);
            }
            return hostsResolver -> Collections.emptyList();
        });
    }
}

