/*
 * Decompiled with CFR 0.152.
 */
package io.crate.azure.management;

import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.management.compute.ComputeManagementClient;
import com.microsoft.azure.management.compute.ComputeManagementService;
import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderService;
import com.microsoft.azure.utility.AuthHelper;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.Builder;
import com.microsoft.windowsazure.core.DefaultBuilder;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import io.crate.azure.AzureConfiguration;
import io.crate.azure.management.AzureComputeService;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class AzureComputeServiceImpl
extends AbstractLifecycleComponent
implements AzureComputeService {
    private static final Logger LOGGER = LogManager.getLogger(AzureComputeServiceImpl.class);
    private final String resourceGroupName;
    private final String subscriptionId;
    private final String tenantId;
    private final String appId;
    private final String appSecret;
    private ComputeManagementClient computeManagementClient;
    private NetworkResourceProviderClient networkResourceClient;
    private Configuration configuration;

    @Inject
    public AzureComputeServiceImpl(Settings settings) {
        this.subscriptionId = (String)AzureComputeService.Management.SUBSCRIPTION_ID.get(settings);
        this.tenantId = (String)AzureComputeService.Management.TENANT_ID.get(settings);
        this.appId = (String)AzureComputeService.Management.APP_ID.get(settings);
        this.appSecret = (String)AzureComputeService.Management.APP_SECRET.get(settings);
        this.resourceGroupName = (String)AzureComputeService.Management.RESOURCE_GROUP_NAME.get(settings);
    }

    @Override
    @Nullable
    public ComputeManagementClient computeManagementClient() {
        if (this.computeManagementClient == null) {
            Configuration conf = this.configuration();
            if (conf == null) {
                return null;
            }
            this.computeManagementClient = ComputeManagementService.create((Configuration)conf);
        }
        return this.computeManagementClient;
    }

    @Override
    @Nullable
    public NetworkResourceProviderClient networkResourceClient() {
        if (this.networkResourceClient == null) {
            Configuration conf = this.configuration();
            if (conf == null) {
                return null;
            }
            this.networkResourceClient = NetworkResourceProviderService.create((Configuration)conf);
        }
        return this.networkResourceClient;
    }

    @Override
    public Configuration configuration() {
        if (this.configuration == null) {
            LOGGER.trace("Creating new Azure configuration for [{}], [{}]", (Object)this.subscriptionId, (Object)this.resourceGroupName);
            this.configuration = this.createConfiguration();
        }
        return this.configuration;
    }

    private Configuration createConfiguration() {
        Configuration conf = null;
        try {
            AuthenticationResult authRes = AuthHelper.getAccessTokenFromServicePrincipalCredentials((String)"https://management.core.windows.net/", (String)"https://login.windows.net/", (String)this.tenantId, (String)this.appId, (String)this.appSecret);
            DefaultBuilder registry = DefaultBuilder.create();
            AzureConfiguration.registerServices((Builder.Registry)registry);
            conf = ManagementConfiguration.configure(null, (Configuration)new Configuration((Builder)registry), (URI)URI.create("https://management.core.windows.net/"), (String)this.subscriptionId, (String)authRes.getAccessToken());
        }
        catch (Exception e) {
            LOGGER.error("Could not create configuration for Azure clients", (Throwable)e);
        }
        return conf;
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        if (this.computeManagementClient != null) {
            try {
                this.computeManagementClient.close();
            }
            catch (IOException e) {
                LOGGER.error("Error while closing Azure computeManagementClient", (Throwable)e);
            }
        }
        if (this.networkResourceClient != null) {
            try {
                this.networkResourceClient.close();
            }
            catch (IOException e) {
                LOGGER.error("Error while closing Azure networkResourceClient", (Throwable)e);
            }
        }
    }

    static final class Azure {
        private static final String ENDPOINT = "https://management.core.windows.net/";
        private static final String AUTH_ENDPOINT = "https://login.windows.net/";

        Azure() {
        }
    }
}

