/*
 * Decompiled with CFR 0.152.
 */
package io.crate.azure.discovery;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.models.NetworkInterface;
import com.microsoft.azure.management.network.models.NetworkInterfaceIpConfiguration;
import com.microsoft.azure.management.network.models.PublicIpAddress;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.Subnet;
import com.microsoft.azure.management.network.models.VirtualNetwork;
import io.crate.azure.management.AzureComputeService;
import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.transport.TransportService;

public class AzureSeedHostsProvider
implements SeedHostsProvider {
    private static final Logger LOGGER = LogManager.getLogger(AzureSeedHostsProvider.class);
    private final AzureComputeService azureComputeService;
    private final TransportService transportService;
    private final NetworkService networkService;
    private final TimeValue refreshInterval;
    private AddressCache cache;
    private final String resourceGroup;
    private final HostType hostType;
    private final String discoveryMethod;

    @Inject
    public AzureSeedHostsProvider(Settings settings, AzureComputeService azureComputeService, TransportService transportService, NetworkService networkService) {
        this.azureComputeService = azureComputeService;
        this.transportService = transportService;
        this.networkService = networkService;
        this.refreshInterval = (TimeValue)AzureComputeService.Discovery.REFRESH.get(settings);
        this.resourceGroup = (String)AzureComputeService.Management.RESOURCE_GROUP_NAME.get(settings);
        this.hostType = HostType.fromString((String)AzureComputeService.Discovery.HOST_TYPE.get(settings));
        this.discoveryMethod = (String)AzureComputeService.Discovery.DISCOVERY_METHOD.get(settings);
    }

    public List<TransportAddress> getSeedAddresses(SeedHostsProvider.HostsResolver hostsResolver) {
        if (this.cache == null) {
            this.cache = new AddressCache(this.refreshInterval, Collections.emptyList());
        }
        return (List)this.cache.getOrRefresh();
    }

    public static HashMap<String, String> retrieveNetInfo(NetworkResourceProviderClient networkResourceProviderClient, String rgName, String ipAddress) throws Exception {
        HashMap<String, String> networkNames = new HashMap<String, String>();
        ArrayList virtualNetworks = networkResourceProviderClient.getVirtualNetworksOperations().list(rgName).getVirtualNetworks();
        for (VirtualNetwork vn : virtualNetworks) {
            ArrayList subnets = vn.getSubnets();
            for (Subnet subnet : subnets) {
                block2: for (ResourceId resourceId : subnet.getIpConfigurations()) {
                    String[] nicURI = resourceId.getId().split("/");
                    NetworkInterface nic = networkResourceProviderClient.getNetworkInterfacesOperations().get(rgName, nicURI[nicURI.length - 3]).getNetworkInterface();
                    ArrayList ips = nic.getIpConfigurations();
                    for (NetworkInterfaceIpConfiguration ipConfiguration : ips) {
                        if (!ipAddress.equals(ipConfiguration.getPrivateIpAddress())) continue;
                        networkNames.put("vnet", vn.getName());
                        networkNames.put("subnet", subnet.getName());
                        continue block2;
                    }
                }
            }
        }
        return networkNames;
    }

    public static List<String> listIPAddresses(NetworkResourceProviderClient networkResourceProviderClient, String rgName, String vnetName, String subnetName, String discoveryMethod, HostType hostType, Logger logger) {
        ArrayList<String> ipList = new ArrayList<String>();
        ArrayList ipConfigurations = new ArrayList();
        try {
            ArrayList subnets = networkResourceProviderClient.getVirtualNetworksOperations().get(rgName, vnetName).getVirtualNetwork().getSubnets();
            if (discoveryMethod.equalsIgnoreCase("vnet")) {
                for (Subnet subnet : subnets) {
                    ipConfigurations.addAll(subnet.getIpConfigurations());
                }
            } else {
                for (Subnet subnet : subnets) {
                    if (!subnet.getName().equalsIgnoreCase(subnetName)) continue;
                    ipConfigurations.addAll(subnet.getIpConfigurations());
                }
            }
            for (ResourceId resourceId : ipConfigurations) {
                String[] nicURI = resourceId.getId().split("/");
                NetworkInterface nic = networkResourceProviderClient.getNetworkInterfacesOperations().get(rgName, nicURI[nicURI.length - 3]).getNetworkInterface();
                ArrayList ips = nic.getIpConfigurations();
                for (NetworkInterfaceIpConfiguration ipConfiguration : ips) {
                    String networkAddress = null;
                    switch (hostType) {
                        case PRIVATE_IP: {
                            InetAddress privateIp = InetAddress.getByName(ipConfiguration.getPrivateIpAddress());
                            if (privateIp != null) {
                                networkAddress = NetworkAddress.format((InetAddress)privateIp);
                                break;
                            }
                            logger.trace("no private ip provided. ignoring [{}]...", (Object)nic.getName());
                            break;
                        }
                        case PUBLIC_IP: {
                            if (ipConfiguration.getPublicIpAddress() != null) {
                                String[] pipID = ipConfiguration.getPublicIpAddress().getId().split("/");
                                PublicIpAddress pip = networkResourceProviderClient.getPublicIpAddressesOperations().get(rgName, pipID[pipID.length - 1]).getPublicIpAddress();
                                networkAddress = NetworkAddress.format((InetAddress)InetAddress.getByName(pip.getIpAddress()));
                            }
                            if (networkAddress != null) break;
                            logger.trace("no public ip provided. ignoring [{}]...", (Object)nic.getName());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Supplied HostType is invalid: " + hostType);
                        }
                    }
                    if (networkAddress == null) {
                        logger.warn("no network address found. ignoring [{}]...", (Object)nic.getName());
                        continue;
                    }
                    ipList.add(networkAddress);
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not retrieve IP addresses for unicast host list", (Throwable)e);
        }
        return ipList;
    }

    public static enum HostType {
        PRIVATE_IP("private_ip"),
        PUBLIC_IP("public_ip");

        private String type;

        private HostType(String type) {
            this.type = type;
        }

        public static HostType fromString(String type) {
            for (HostType hostType : HostType.values()) {
                if (!hostType.type.equalsIgnoreCase(type)) continue;
                return hostType;
            }
            return null;
        }
    }

    private class AddressCache
    extends SingleObjectCache<List<TransportAddress>> {
        AddressCache(TimeValue refreshInterval, List<TransportAddress> initialValue) {
            super(refreshInterval, initialValue);
        }

        protected List<TransportAddress> refresh() {
            InetAddress ipAddress;
            ArrayList<TransportAddress> nodes = new ArrayList<TransportAddress>();
            try {
                ipAddress = AzureSeedHostsProvider.this.networkService.resolvePublishHostAddresses(null);
                LOGGER.trace("ip of current node: [{}]", (Object)ipAddress);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot find publish host address/ip", (Throwable)e);
                return Collections.emptyList();
            }
            NetworkResourceProviderClient client = AzureSeedHostsProvider.this.azureComputeService.networkResourceClient();
            if (client == null) {
                return Collections.emptyList();
            }
            try {
                HashMap<String, String> networkNameOfCurrentHost = AzureSeedHostsProvider.retrieveNetInfo(client, AzureSeedHostsProvider.this.resourceGroup, NetworkAddress.format((InetAddress)ipAddress));
                if (networkNameOfCurrentHost.size() == 0) {
                    LOGGER.error("Could not find vnet or subnet of current host");
                    return Collections.emptyList();
                }
                List<String> ipAddresses = AzureSeedHostsProvider.listIPAddresses(client, AzureSeedHostsProvider.this.resourceGroup, networkNameOfCurrentHost.get("vnet"), networkNameOfCurrentHost.get("subnet"), AzureSeedHostsProvider.this.discoveryMethod, AzureSeedHostsProvider.this.hostType, LOGGER);
                for (String networkAddress : ipAddresses) {
                    for (TransportAddress transportAddress : AzureSeedHostsProvider.this.transportService.addressesFromString(networkAddress)) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("adding {}, transport_address {}", (Object)networkAddress, (Object)transportAddress);
                        }
                        nodes.add(transportAddress);
                    }
                }
            }
            catch (UnknownHostException e) {
                LOGGER.error("Error occurred in getting hostname");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
            LOGGER.debug("{} node(s) added", (Object)nodes.size());
            return nodes;
        }
    }
}

