/*
 * Decompiled with CFR 0.152.
 */
package io.crate.azure;

import com.microsoft.windowsazure.core.Builder;
import com.microsoft.windowsazure.core.utils.Exports;
import io.crate.azure.management.AzureComputeService;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoveryModule;

public class AzureConfiguration {
    public static final String AZURE = "azure";
    public static final String VNET = "vnet";
    public static final String SUBNET = "subnet";

    public static void registerServices(Builder.Registry registry) {
        new com.microsoft.windowsazure.core.pipeline.apache.Exports().register(registry);
        new com.microsoft.windowsazure.core.pipeline.jersey.Exports().register(registry);
        new Exports().register(registry);
        new com.microsoft.windowsazure.credentials.Exports().register(registry);
        new com.microsoft.windowsazure.management.configuration.Exports().register(registry);
        new com.microsoft.azure.management.compute.Exports().register(registry);
        new com.microsoft.azure.management.storage.Exports().register(registry);
        new com.microsoft.azure.management.network.Exports().register(registry);
    }

    public static boolean isCloudReady(Settings settings) {
        return settings.getAsBoolean("cloud.enabled", Boolean.valueOf(true));
    }

    public static boolean isDiscoveryReady(Settings settings, Logger logger) {
        if (!AzureConfiguration.isCloudReady(settings)) {
            logger.trace("cloud settings are disabled");
            return false;
        }
        if (!AZURE.equalsIgnoreCase(settings.get(DiscoveryModule.DISCOVERY_SEED_PROVIDERS_SETTING.getKey()))) {
            logger.trace("{} not set to {}", (Object)DiscoveryModule.DISCOVERY_SEED_PROVIDERS_SETTING.getKey(), (Object)AZURE);
            return false;
        }
        if (AzureConfiguration.isPropertyMissing(settings, AzureComputeService.Management.SUBSCRIPTION_ID.getKey()) || AzureConfiguration.isPropertyMissing(settings, AzureComputeService.Management.RESOURCE_GROUP_NAME.getKey()) || AzureConfiguration.isPropertyMissing(settings, AzureComputeService.Management.TENANT_ID.getKey()) || AzureConfiguration.isPropertyMissing(settings, AzureComputeService.Management.APP_ID.getKey()) || AzureConfiguration.isPropertyMissing(settings, AzureComputeService.Management.APP_SECRET.getKey())) {
            logger.warn("one or more azure discovery settings are missing. Check crate.yml file. Should have [{}], [{}], [{}] and [{}].", AzureComputeService.Management.SUBSCRIPTION_ID, AzureComputeService.Management.RESOURCE_GROUP_NAME, AzureComputeService.Management.TENANT_ID, AzureComputeService.Management.APP_ID, AzureComputeService.Management.APP_SECRET);
            return false;
        }
        String discoveryType = (String)AzureComputeService.Discovery.DISCOVERY_METHOD.get(settings);
        if (!SUBNET.equalsIgnoreCase(discoveryType) && !VNET.equalsIgnoreCase(discoveryType) && discoveryType != null) {
            logger.warn("{} must be set to {} or {}. Ignoring value {}", (Object)AzureComputeService.Discovery.DISCOVERY_METHOD.getKey(), (Object)VNET, (Object)SUBNET, (Object)discoveryType);
        }
        logger.trace("all required properties for azure discovery are set!");
        return true;
    }

    private static boolean isPropertyMissing(Settings settings, String name) throws ElasticsearchException {
        return !Strings.hasText((String)settings.get(name));
    }
}

