/*!
   This file is part of ColorZilla
  
   Written by Alex Sirota (alex @ iosart.com)
  
   Copyright (c) iosart labs llc 2011, All Rights Reserved
   
   Please do not use without permission
*/
if("undefined"==typeof ColorZilla||!ColorZilla)var ColorZilla={};!function(){var a=ColorZilla;a.czHSVTriple=function(a,b,c){this.h=a,this.s=b,this.v=c,this.toString=function(){return"("+this.h+", "+this.s+", "+this.v+")"}},a.czHSLTriple=function(a,b,c){this.h=a,this.s=b,this.l=c,this.toString=function(){return"("+this.h+", "+this.s+", "+this.l+")"}},a.czRGBTriple=function(a,b,c){this.r=a,this.g=b,this.b=c,this.toString=function(){return"("+this.r+", "+this.g+", "+this.b+")"}},a.czLABTriple=function(a,b,c){this.l=a,this.a=b,this.b=c,this.toString=function(){return"("+this.l+", "+this.a+", "+this.b+")"}},a.czXYZTriple=function(a,b,c){this.x=a,this.y=b,this.z=c,this.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"}},a.czCMYKQuadruple=function(a,b,c,d){this.c=a,this.m=b,this.y=c,this.k=d,this.toString=function(){return"("+this.c+", "+this.m+", "+this.y+", "+this.k+")"}},a.czRGBToColor=function(a,b,c){return a|b<<8|c<<16},a.czGetRValue=function(a){return 255&a},a.czGetGValue=function(a){return a>>8&255},a.czGetBValue=function(a){return a>>16&255},a.czIntToPercent=function(a){return Math.floor(100*a/255+.5)},a.czIntToDegrees=function(a){return Math.floor(360*a/255+.5)},a.czDecimalToHexa=function(a){var b=a.toString(16);return b.length<2&&(b="0"+b),b},a.czColToRGBPercentageAttribute=function(b){var c=a.czIntToPercent(a.czGetRValue(b))+"%, "+a.czIntToPercent(a.czGetGValue(b))+"%, "+a.czIntToPercent(a.czGetBValue(b))+"%";return"rgb("+c+")"},a.czColToHSLAttribute=function(b){var c=a.czRGBToHSL(a.czGetRValue(b),a.czGetGValue(b),a.czGetBValue(b)),d=c.h+", "+a.czIntToPercent(c.s)+"%, "+a.czIntToPercent(c.l)+"%";return"hsl("+d+")"},a.czColToRGBAttribute=function(b){var c=a.czGetRValue(b)+", "+a.czGetGValue(b)+", "+a.czGetBValue(b);return"rgb("+c+")"},a.czRGBAttributeToCol=function(b){var c=b.split("(");b=c[1];var d=b.split(")");b=d[0];var e=b.split(",");return a.czRGBToColor(e[0],e[1],e[2])},a.czColToRGBHexaAttribute=function(b){var c=a.czDecimalToHexa(a.czGetRValue(b))+a.czDecimalToHexa(a.czGetGValue(b))+a.czDecimalToHexa(a.czGetBValue(b));return a.gbCZLowerCaseHexa||(c=c.toUpperCase()),"#"+c},a.czRGBHexaAttributeToCol=function(b){var c=b.substr(1,2),d=b.substr(3,2),e=b.substr(5,2);return c=parseInt(c,16),d=parseInt(d,16),e=parseInt(e,16),a.czRGBToColor(c,d,e)},a.czRGBToGrayscale=function(a,b,c){return.3*a+.59*b+.11*c},a.czColToSpecificColorFormat=function(b,c){var d;switch(c){case"rgb":d=a.czColToRGBAttribute(b);break;case"rgb-perc":d=a.czColToRGBPercentageAttribute(b);break;case"hsl":d=a.czColToHSLAttribute(b);break;case"hex-no-hash":d=a.czColToRGBHexaAttribute(b),d=d.substring(1);break;case"hex":d=a.czColToRGBHexaAttribute(b);break;default:d=a.czColToRGBHexaAttribute(b)}return d},a.czRGBToHSV=function(b,c,d){var e,f,g,h,i;return h=Math.max(b,c,d),i=h-Math.min(b,c,d),f=0==h?0:255*i/h,0==f?e=0:b==h?e=60*(c-d)/i:c==h?e=120+60*(d-b)/i:d==h&&(e=240+60*(b-c)/i),0>e&&(e+=360),e=Math.round(255*e/360),f=Math.round(f),g=h,new a.czHSVTriple(e,f,g)},a.czRGBToHSL=function(b,c,d){b/=255,c/=255,d/=255;var e,f,g=Math.max(b,c,d),h=Math.min(b,c,d),i=(g+h)/2;if(g==h)e=f=0;else{var j=g-h;switch(f=j/(i>.5?2-g-h:g+h),g){case b:e=(c-d)/j+(d>c?6:0);break;case c:e=(d-b)/j+2;break;case d:e=(b-c)/j+4}e/=6}return e=Math.round(360*e),f=Math.round(255*f),i=Math.round(255*i),new a.czHSLTriple(e,f,i)},a.czRGBToXYZ=function(b,c,d){function e(a){return a>.04045?Math.pow((a+.055)/1.055,2.4):a/12.92}b/=255,c/=255,d/=255,b=e(b),c=e(c),d=e(d);var f=.4124*b+.3576*c+.1805*d,g=.2126*b+.7152*c+.0722*d,h=.0193*b+.1192*c+.9505*d;return f*=100,g*=100,h*=100,new a.czXYZTriple(f,g,h)},a.czXYZToRGB=function(b,c,d){function e(a){return a>.0031308?1.055*Math.pow(a,1/2.4)-.055:12.92*a}function f(a){return 0>a?0:a>255?255:a}b/=100,c/=100,d/=100;var g=3.2406*b-1.5372*c-.4986*d,h=-.9689*b+1.8758*c+.0415*d,i=.0557*b-.204*c+1.057*d;return g=e(g),h=e(h),i=e(i),g=f(Math.round(255*g)),h=f(Math.round(255*h)),i=f(Math.round(255*i)),new a.czRGBTriple(g,h,i)},a.czXYZToLAB=function(b,c,d){function e(a){const b=.00885645;return a>b?Math.pow(a,.3333333333):7.787037037037*a+.13793103448}var f=96.422,g=100,h=82.521,i=e(b/f),j=e(c/g),k=e(d/h),l=116*j-16,m=500*(i-j),n=200*(j-k);return new a.czLABTriple(l,m,n)},a.czLABToXYZ=function(b,c,d){function e(a){const b=6/29;return a>b?Math.pow(a,3):.128418549*(a-.137931)}var f=(b+16)/116,g=f+c/500,h=f-d/200,i=e(g),j=e(f),k=e(h),l=96.422,m=100,n=82.521;return i*=l,j*=m,k*=n,new a.czXYZTriple(i,j,k)},a.czRGBToLAB=function(b,c,d){var e=a.czRGBToXYZ(b,c,d);return a.czXYZToLAB(e.x,e.y,e.z)},a.czLABToRGB=function(b,c,d){var e=a.czLABToXYZ(parseFloat(b),parseFloat(c),parseFloat(d));return a.czXYZToRGB(e.x,e.y,e.z)},a.czHSVToRGB=function(b,c,d){var e,f,g,h,i,j,k,l;if(0==c)e=f=g=d;else{switch(b=359*b/15300,c/=255,d/=255,h=Math.floor(b),i=b-h,j=d*(1-c),k=d*(1-c*i),l=d*(1-c*(1-i)),h){case 0:e=d,f=l,g=j;break;case 1:e=k,f=d,g=j;break;case 2:e=j,f=d,g=l;break;case 3:e=j,f=k,g=d;break;case 4:e=l,f=j,g=d;break;default:e=d,f=j,g=k}e=Math.round(255*e),f=Math.round(255*f),g=Math.round(255*g)}return new a.czRGBTriple(e,f,g)},a.czRGBToCMYK=function(b,c,d){var e=255-b,f=255-c,g=255-d,h=Math.min(e,Math.min(f,g));return 255==h?e=f=g=0:(e=Math.round(255*((e-h)/(255-h))),f=Math.round(255*((f-h)/(255-h))),g=Math.round(255*((g-h)/(255-h)))),new a.czCMYKQuadruple(e,f,g,h)},a.czCMYKToRGB=function(c,d,e,f){return c/=255,d/=255,e/=255,f/=255,c=c*(1-f)+f,d=d*(1-f)+f,e=e*(1-f)+f,r=Math.round(255*(1-c)),g=Math.round(255*(1-d)),b=Math.round(255*(1-e)),new a.czRGBTriple(r,g,b)},a.czGetColorLightness=function(b){var c=a.czGetRValue(b),d=a.czGetGValue(b),e=a.czGetBValue(b);return Math.max(c,d,e)},a.czHexaAttributeToPredefinedColor=function(a){return a=a.toLowerCase(),"#800000"==a?"maroon":"#ff0000"==a?"red":"#ffa500"==a?"orange":"#ffff00"==a?"yellow":"#808000"==a?"olive":"#800080"==a?"purple":"#ff00ff"==a?"fuchsia":"#ffffff"==a?"white":"#00ff00"==a?"lime":"#008000"==a?"green":"#000080"==a?"navy":"#0000ff"==a?"blue":"#00ffff"==a?"aqua":"#008080"==a?"teal":"#000000"==a?"black":"#c0c0c0"==a?"silver":"#808080"==a?"gray":null},a.czFixHexValue=function(a){return 7!=a.length||"#"!=a.substr(0,1)?"#000000":a},a.czFixByteValue=function(a){return a>255?a=255:0>a&&(a=0),a},a.czFix100Value=function(a){return a>100?a=100:0>a&&(a=0),a},a.czFixLabABValue=function(a){return a>127?a=127:-128>a&&(a=-128),a},a.czValidateByteValue=function(a){return 0>a||a>255?!1:!0},a.czCompareTwoStrings=function(a,b){return b>a?-1:a>b?1:0},a.czClipString=function(a,b){if("undefined"==typeof b&&(b=15),!a)return a;var c;return c=a.length>b?a.substr(0,b)+"...":a},a.czGetColorPalettePermalink=function(b,c,d){for(var e=[],f=0;f<b.length;f++){var g=b[f],h=a.czColToRGBHexaAttribute(g).substring(1);e.push(h)}e.length>256&&(e=e.slice(0,255)),b=e.join("+");var i="http://colorzilla.com/colors",j=i+"/"+e.join("+");d&&(d.length>64&&(d=d.substr(0,64)),j+="/"+encodeURIComponent(d));var k=null;return c&&(k=c,k=k.replace(/^https?:\/\//,""),k=k.replace(/\?.*$/,""),k=k.replace(/#.*$/,""),k=encodeURIComponent(k)),k&&j.length+k.length<1900&&(j+="?source-url="+k),j},a.gbCZLowerCaseHexa=!1}();